/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.jms.AccessMode;
import io.confluent.kafka.jms.JMSIOException;
import io.confluent.kafka.jms.JsonHeaderValue;
import io.confluent.kafka.jms.JsonHeaderValueType;
import io.confluent.kafka.jms.KafkaMessage;
import io.confluent.kafka.jms.KafkaMessageQueue;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaMapMessage
extends KafkaMessage
implements MapMessage {
    static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log;
    public static final String MESSAGE_TYPE = "map";
    Map<String, Object> payload;
    AccessMode accessMode;
    static final Set<Class<? extends Serializable>> ALLOWED_TYPES;

    @Override
    protected String messageType() {
        return MESSAGE_TYPE;
    }

    @Override
    protected byte[] serializeBody() throws JMSException {
        LinkedHashMap<String, JsonHeaderValue> jsonHeaders = new LinkedHashMap<String, JsonHeaderValue>(this.payload.size());
        for (Map.Entry<String, Object> entry : this.payload.entrySet()) {
            jsonHeaders.put(entry.getKey(), new JsonHeaderValue(entry.getValue()));
        }
        try {
            byte[] buffer = JSON_OBJECT_MAPPER.writeValueAsBytes(jsonHeaders);
            if (log.isTraceEnabled()) {
                log.trace("serializeBody() - Serialized as {}", (Object)new String(buffer, Charsets.UTF_8));
            }
            return buffer;
        }
        catch (JsonProcessingException e) {
            throw new JMSIOException("Exception thrown while serializing body.", e);
        }
    }

    private Map<String, Object> deserializeBody(byte[] body) throws JMSException {
        try {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            Map jsonHeaders = (Map)JSON_OBJECT_MAPPER.readValue(body, (TypeReference)new TypeReference<Map<String, JsonHeaderValue>>(){});
            for (Map.Entry entry : jsonHeaders.entrySet()) {
                String key = (String)entry.getKey();
                Object value = new JsonHeaderValue((JsonHeaderValueType)((JsonHeaderValue)entry.getValue()).type, (Object)((JsonHeaderValue)entry.getValue()).value).value;
                log.trace("deserializeBody() - Setting '{}' to '{}'", (Object)key, value);
                result.put(key, value);
            }
            return result;
        }
        catch (IOException e) {
            throw new JMSIOException("Exception thrown while deserializing body.", e);
        }
    }

    @Override
    public void clearBody() throws JMSException {
        this.payload.clear();
        this.accessMode = AccessMode.ReadWrite;
    }

    public KafkaMapMessage(KafkaMessageQueue messageQueue, ConsumerRecord<byte[], byte[]> record, boolean allowOutOfOrderAcknowledge) {
        super(messageQueue, record, allowOutOfOrderAcknowledge);
        try {
            this.payload = this.deserializeBody((byte[])record.value());
            this.accessMode = AccessMode.ReadOnly;
        }
        catch (JMSException e) {
            throw new IllegalStateException(e);
        }
    }

    public KafkaMapMessage() {
        this.accessMode = AccessMode.ReadWrite;
        this.payload = new HashMap<String, Object>();
    }

    <T> T get(String name, Class<T> cls) {
        log.trace("get() - name = '{}'", (Object)name);
        Object value = this.payload.get(name);
        if (null == value) {
            return null;
        }
        return (T)value;
    }

    public boolean getBoolean(String name) throws JMSException {
        return this.get(name, Boolean.class);
    }

    public byte getByte(String name) throws JMSException {
        return this.get(name, Byte.class);
    }

    public short getShort(String name) throws JMSException {
        return this.get(name, Short.class);
    }

    public char getChar(String name) throws JMSException {
        return this.get(name, Character.class).charValue();
    }

    public int getInt(String name) throws JMSException {
        return this.get(name, Integer.class);
    }

    public long getLong(String name) throws JMSException {
        return this.get(name, Long.class);
    }

    public float getFloat(String name) throws JMSException {
        return this.get(name, Float.class).floatValue();
    }

    public double getDouble(String name) throws JMSException {
        return this.get(name, Double.class);
    }

    public String getString(String name) throws JMSException {
        return this.get(name, String.class);
    }

    public byte[] getBytes(String name) throws JMSException {
        return this.get(name, byte[].class);
    }

    public Object getObject(String name) throws JMSException {
        return this.get(name, Object.class);
    }

    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(this.payload.keySet());
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.setObject(name, value);
    }

    public void setByte(String name, byte value) throws JMSException {
        this.setObject(name, value);
    }

    public void setShort(String name, short value) throws JMSException {
        this.setObject(name, value);
    }

    public void setChar(String name, char value) throws JMSException {
        this.setObject(name, Character.valueOf(value));
    }

    public void setInt(String name, int value) throws JMSException {
        this.setObject(name, value);
    }

    public void setLong(String name, long value) throws JMSException {
        this.setObject(name, value);
    }

    public void setFloat(String name, float value) throws JMSException {
        this.setObject(name, Float.valueOf(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        this.setObject(name, value);
    }

    public void setString(String name, String value) throws JMSException {
        this.setObject(name, value);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.setObject(name, value);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        byte[] buffer = new byte[length];
        System.arraycopy(value, offset, buffer, 0, length);
        this.setBytes(name, value);
    }

    public void setObject(String name, Object value) throws JMSException {
        log.trace("setObject() - name = '{}' value = '{}'", (Object)name, value);
        if (null == name || name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be null or empty.");
        }
        if (null == value) {
            throw new MessageFormatException("value cannot be null.");
        }
        if (this.accessMode == AccessMode.ReadOnly) {
            throw new MessageNotWriteableException("Message not writable.");
        }
        Class<?> valueClass = value.getClass();
        if (!ALLOWED_TYPES.contains(valueClass)) {
            String message = String.format("%s is not an allowed class. Only %s are supported.", valueClass, Joiner.on((String)", ").join(ALLOWED_TYPES));
            throw new MessageFormatException(message);
        }
        this.payload.put(name, value);
    }

    public boolean itemExists(String name) throws JMSException {
        return this.payload.containsKey(name);
    }

    static {
        JSON_OBJECT_MAPPER.configure(SerializationFeature.INDENT_OUTPUT, false);
        JSON_OBJECT_MAPPER.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);
        log = LoggerFactory.getLogger(KafkaMapMessage.class);
        ALLOWED_TYPES = ImmutableSet.of(Byte.class, Boolean.class, Short.class, Character.class, Integer.class, Long.class, (Object[])new Class[]{Float.class, Double.class, byte[].class, String.class});
    }
}

