/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.KafkaConnectionFactory;
import io.confluent.kafka.jms.KafkaContext;
import io.confluent.kafka.jms.KafkaDestination;
import io.confluent.kafka.jms.KafkaQueue;
import io.confluent.kafka.jms.KafkaTopic;
import io.confluent.kafka.jms.NameParserImpl;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaInitialContextFactory
implements InitialContextFactory {
    private static final Logger log = LoggerFactory.getLogger(KafkaInitialContextFactory.class);
    private static final String[] CONNECTION_FACTORY_NAMES = new String[]{"ConnectionFactory", "QueueConnectionFactory", "TopicConnectionFactory"};
    private static final String CLUSTER_PREFIX = "kafka.";
    private static final String TOPIC_PREFIX = "topic.";
    private static final String QUEUE_PREFIX = "queue.";

    public Context getInitialContext(Hashtable environment) throws NamingException {
        log.trace("getInitialContext");
        if (null == environment) {
            throw new NamingException("environment cannot be null.");
        }
        Hashtable<String, Object> kafkaSettings = this.kafkaSettings(environment);
        NameParserImpl nameParser = new NameParserImpl();
        KafkaContext kafkaContext = new KafkaContext(kafkaSettings);
        kafkaSettings = KafkaInitialContextFactory.applyKafkaPropertyTranslations(kafkaSettings);
        for (String connectionFactoryKey : CONNECTION_FACTORY_NAMES) {
            if (log.isTraceEnabled()) {
                log.trace("Creating connection factory for {}.", (Object)connectionFactoryKey);
            }
            KafkaConnectionFactory connectionFactory = new KafkaConnectionFactory(kafkaSettings);
            kafkaContext.bind(new CompositeName(connectionFactoryKey), (Object)connectionFactory);
        }
        KafkaInitialContextFactory.addTopics(environment, kafkaContext, nameParser);
        KafkaInitialContextFactory.addQueues(environment, kafkaContext, nameParser);
        return kafkaContext;
    }

    Hashtable<String, Object> kafkaSettings(Hashtable environment) {
        Hashtable<String, Object> result = new Hashtable<String, Object>(environment);
        for (Object k : environment.keySet()) {
            String key = k.toString();
            if (!key.startsWith(CLUSTER_PREFIX)) continue;
            String kafkaKey = key.substring(CLUSTER_PREFIX.length());
            Object value = environment.get(k);
            result.put(kafkaKey, value);
        }
        return result;
    }

    private static Hashtable<String, Object> applyKafkaPropertyTranslations(Map<String, Object> settings) {
        Hashtable<String, String> translations = new Hashtable<String, String>();
        translations.put("javax.net.ssl.trustStore", "ssl.truststore.location");
        translations.put("javax.net.ssl.trustStoreType", "ssl.truststore.type");
        translations.put("javax.net.ssl.trustStorePassword", "ssl.truststore.password");
        translations.put("javax.net.ssl.keyStore", "ssl.keystore.location");
        translations.put("javax.net.ssl.keyStoreType", "ssl.keystore.type");
        translations.put("javax.net.ssl.keyStorePassword", "ssl.keystore.password");
        Hashtable<String, Object> result = new Hashtable<String, Object>(settings);
        for (Map.Entry translation : translations.entrySet()) {
            String javaProperty = (String)translation.getKey();
            String kafkaProperty = (String)translation.getValue();
            if (result.containsKey(kafkaProperty)) continue;
            if (result.containsKey(javaProperty)) {
                Object v = result.get(javaProperty);
                result.remove(javaProperty);
                result.put(kafkaProperty, v);
                continue;
            }
            if (System.getProperty(kafkaProperty) != null) {
                result.put(kafkaProperty, System.getProperty(kafkaProperty));
                continue;
            }
            if (System.getProperty(javaProperty) == null) continue;
            result.put(kafkaProperty, System.getProperty(javaProperty));
        }
        return result;
    }

    static void addDestination(Hashtable environment, Context context, NameParser nameParser, String prefix) throws NamingException {
        block8: for (Object k : environment.keySet()) {
            String key = k.toString();
            if (!key.startsWith(prefix)) continue;
            Name name = nameParser.parse(key.substring(prefix.length()));
            String value = environment.get(k).toString();
            log.trace("Found destination. key='{}' jndiKey='{}' value='{}'", new Object[]{k, name, value});
            switch (prefix) {
                case "topic.": {
                    KafkaTopic topic = new KafkaTopic(value);
                    context.bind(name, (Object)topic);
                    continue block8;
                }
                case "queue.": {
                    KafkaQueue queue = new KafkaQueue(value);
                    context.bind(name, (Object)queue);
                    continue block8;
                }
            }
            KafkaDestination destination = new KafkaDestination(value);
            context.bind(name, (Object)destination);
        }
    }

    static void addTopics(Hashtable environment, Context context, NameParser nameParser) throws NamingException {
        KafkaInitialContextFactory.addDestination(environment, context, nameParser, TOPIC_PREFIX);
    }

    static void addQueues(Hashtable environment, Context context, NameParser nameParser) throws NamingException {
        KafkaInitialContextFactory.addDestination(environment, context, nameParser, QUEUE_PREFIX);
    }
}

