/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.ConsumerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;

class ConsumerFactoryImpl
implements ConsumerFactory {
    final Map<String, Object> settings;

    ConsumerFactoryImpl(Map<String, Object> settings) {
        this.settings = settings;
    }

    @Override
    public Consumer create(boolean forQueue) {
        HashMap<String, Object> settingsCopy = new HashMap<String, Object>(this.settings);
        if (!settingsCopy.containsKey("auto.offset.reset")) {
            settingsCopy.put("auto.offset.reset", forQueue ? "earliest" : "latest");
        }
        if (!settingsCopy.containsKey("group.id")) {
            UUID uuid = UUID.randomUUID();
            settingsCopy.put("group.id", forQueue ? "confluent-jms" : "confluent-jms-" + uuid.toString());
        }
        settingsCopy.put("client.id", settingsCopy.get("client.id") + "-" + UUID.randomUUID().toString());
        return new KafkaConsumer(settingsCopy);
    }
}

