/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.format;

import io.confluent.connect.s3.storage.IORecordWriter;
import io.confluent.connect.s3.util.S3ErrorUtils;
import io.confluent.connect.storage.format.RecordWriter;
import java.io.IOException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3RetriableRecordWriter
implements RecordWriter {
    private static final Logger log = LoggerFactory.getLogger(S3RetriableRecordWriter.class);
    private final IORecordWriter writer;

    public S3RetriableRecordWriter(IORecordWriter writer) {
        if (writer == null) {
            log.debug("S3 Retriable record writer was passed a null writer (IORecordWriter)");
            throw new NullPointerException("S3 Retriable record writer was passed a null writer (IORecordWriter)");
        }
        this.writer = writer;
    }

    public void write(SinkRecord sinkRecord) {
        try {
            this.writer.write(sinkRecord);
        }
        catch (IOException e) {
            S3ErrorUtils.throwConnectException(e);
        }
    }

    public void commit() {
        try {
            this.writer.commit();
        }
        catch (IOException e) {
            S3ErrorUtils.throwConnectException(e);
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            S3ErrorUtils.throwConnectException(e);
        }
    }
}

