/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.format;

import io.confluent.connect.s3.format.RecordView;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordViews {
    private static final Logger log = LoggerFactory.getLogger(RecordViews.class);

    private static abstract class BaseRecordView
    implements RecordView {
        private BaseRecordView() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static final class HeaderRecordView
    extends BaseRecordView {
        private static final String HEADER_FIELD_NAME = "headers";
        private static final String HEADER_STRUCT_NAME = "RecordHeaders";
        static final Schema SINGLE_HEADER_SCHEMA = SchemaBuilder.struct().field("key", Schema.STRING_SCHEMA).field("value", Schema.STRING_SCHEMA).build();

        @Override
        public Schema getViewSchema(SinkRecord record, boolean enveloped) {
            Schema headerSchema = SchemaBuilder.array((Schema)SINGLE_HEADER_SCHEMA).build();
            if (enveloped) {
                headerSchema = SchemaBuilder.struct().name(HEADER_STRUCT_NAME).field(HEADER_FIELD_NAME, headerSchema).build();
            }
            log.debug("Created header record view schema.");
            return headerSchema;
        }

        @Override
        public Object getView(SinkRecord record, boolean enveloped) {
            Struct view = StreamSupport.stream(record.headers().spliterator(), false).map(h -> new Struct(SINGLE_HEADER_SCHEMA).put("key", (Object)h.key()).put("value", (Object)Values.convertToString((Schema)h.schema(), (Object)h.value()))).collect(Collectors.toList());
            if (enveloped) {
                view = new Struct(this.getViewSchema(record, true)).put(HEADER_FIELD_NAME, view);
            }
            return view;
        }

        @Override
        public String getExtension() {
            return ".headers";
        }
    }

    public static final class KeyRecordView
    extends BaseRecordView {
        private static final String KEY_FIELD_NAME = "key";
        private static final String KEY_STRUCT_NAME = "RecordKey";

        @Override
        public Schema getViewSchema(SinkRecord record, boolean enveloped) {
            Schema keySchema = record.keySchema();
            if (enveloped) {
                keySchema = SchemaBuilder.struct().name(KEY_STRUCT_NAME).field(KEY_FIELD_NAME, keySchema).build();
            }
            log.debug("Created key record view schema.");
            return keySchema;
        }

        @Override
        public Object getView(SinkRecord record, boolean enveloped) {
            Object view = record.key();
            if (enveloped) {
                view = new Struct(this.getViewSchema(record, true)).put(KEY_FIELD_NAME, view);
            }
            return view;
        }

        @Override
        public String getExtension() {
            return ".keys";
        }
    }

    public static final class ValueRecordView
    extends BaseRecordView {
        @Override
        public Schema getViewSchema(SinkRecord record, boolean enveloped) {
            return record.valueSchema();
        }

        @Override
        public Object getView(SinkRecord record, boolean enveloped) {
            return record.value();
        }

        @Override
        public String getExtension() {
            return "";
        }
    }
}

