/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3;

import io.confluent.connect.s3.S3SinkConnectorConfig;
import io.confluent.connect.s3.format.bytearray.ByteArrayFormat;
import io.confluent.connect.s3.format.json.JsonFormat;
import io.confluent.connect.s3.storage.CompressionType;
import io.confluent.connect.storage.format.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3SinkConnectorValidator {
    private static final Logger log = LoggerFactory.getLogger(S3SinkConnectorValidator.class);
    public static final Map<CompressionType, Set<Class<? extends Format>>> COMPRESSION_SUPPORTED_FORMATS = Collections.unmodifiableMap(new HashMap<CompressionType, Set<Class<? extends Format>>>(){
        {
            this.put(CompressionType.GZIP, new HashSet<Class>(Arrays.asList(JsonFormat.class, ByteArrayFormat.class)));
        }
    });
    public static final String FORMAT_CONFIG_ERROR_MESSAGE = "Compression Type %s not valid for %s format class: ( %s ).";
    private static final String ACCESS_MODE_ERROR_MESSAGE = "Both accelerate mode and path style access are being enabled. These options are mutually exclusive and cannot be enabled together. Please disable one of them";
    private final Map<String, String> connectorConfigs;
    private final ConfigDef config;
    protected final Map<String, ConfigValue> valuesByKey;

    public S3SinkConnectorValidator(ConfigDef config, Map<String, String> connectorConfigs, List<ConfigValue> configValues) {
        this.config = config;
        this.connectorConfigs = connectorConfigs;
        this.valuesByKey = new HashMap<String, ConfigValue>();
        for (ConfigValue configValue : configValues) {
            this.valuesByKey.put(configValue.name(), configValue);
        }
    }

    public Config validate() {
        log.info("Validating s3 Configs");
        S3SinkConnectorConfig s3SinkConnectorConfig = null;
        try {
            s3SinkConnectorConfig = new S3SinkConnectorConfig(this.config, this.connectorConfigs);
        }
        catch (ConfigException exception) {
            log.error("Configuration not ready for cross validation.", (Throwable)exception);
        }
        if (s3SinkConnectorConfig != null) {
            this.validateCompression(s3SinkConnectorConfig.getCompressionType(), s3SinkConnectorConfig.formatClass(), s3SinkConnectorConfig.storeKafkaKeys(), s3SinkConnectorConfig.keysFormatClass(), s3SinkConnectorConfig.storeKafkaHeaders(), s3SinkConnectorConfig.headersFormatClass());
            this.validateTombstoneWriter(s3SinkConnectorConfig.isTombstoneWriteEnabled(), s3SinkConnectorConfig.storeKafkaKeys());
            this.validateWanModeAndPathStyleCompatibility(s3SinkConnectorConfig);
        }
        return new Config(new ArrayList<ConfigValue>(this.valuesByKey.values()));
    }

    public void validateCompression(CompressionType compressionType, Class formatClass, boolean storeKafkaKeys, Class keysFormatClass, boolean storeKafkaHeaders, Class headersFormatClass) {
        if (!compressionType.equals((Object)CompressionType.NONE)) {
            Set<Class<? extends Format>> validFormats = COMPRESSION_SUPPORTED_FORMATS.get((Object)compressionType);
            if (!validFormats.contains(formatClass)) {
                this.recordErrors(String.format(FORMAT_CONFIG_ERROR_MESSAGE, compressionType.name, "data", formatClass.getName()), "format.class", "s3.compression.type");
            }
            if (storeKafkaKeys && !validFormats.contains(keysFormatClass)) {
                this.recordErrors(String.format(FORMAT_CONFIG_ERROR_MESSAGE, compressionType.name, "keys", keysFormatClass.getName()), "store.kafka.keys", "keys.format.class", "s3.compression.type");
            }
            if (storeKafkaHeaders && !validFormats.contains(headersFormatClass)) {
                this.recordErrors(String.format(FORMAT_CONFIG_ERROR_MESSAGE, compressionType.name, "headers", headersFormatClass.getName()), "store.kafka.headers", "headers.format.class", "s3.compression.type");
            }
        }
    }

    public void validateTombstoneWriter(boolean isTombstoneWriteEnabled, boolean isStoreKeysEnabled) {
        if (isTombstoneWriteEnabled && !isStoreKeysEnabled) {
            this.recordErrors("Writing Kafka record keys to storage is mandatory when tombstone writing is enabled.", "store.kafka.keys", "behavior.on.null.values");
        }
    }

    private void validateWanModeAndPathStyleCompatibility(S3SinkConnectorConfig s3SinkConnectorConfig) {
        boolean s3WanModeEnabled = s3SinkConnectorConfig.getBoolean("s3.wan.mode");
        boolean pathStyleAccessEnabled = s3SinkConnectorConfig.getBoolean("s3.path.style.access.enabled");
        if (s3WanModeEnabled && pathStyleAccessEnabled) {
            this.recordErrors(ACCESS_MODE_ERROR_MESSAGE, "s3.wan.mode", "s3.path.style.access.enabled");
        }
    }

    private void recordErrors(String message, String ... keys) {
        log.error("Validation Failed with error: " + message);
        for (String key : keys) {
            this.recordError(message, key);
        }
    }

    private void recordError(String message, String key) {
        Objects.requireNonNull(key);
        if (!key.equals("")) {
            ConfigValue value = this.valuesByKey.get(key);
            if (!message.equals("")) {
                value.addErrorMessage(message);
            }
        }
    }
}

