/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Schema;

public class StringUtils {
    public static <T> String join(Iterable<T> elements, String delim) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (T elem : elements) {
            if (first) {
                first = false;
            } else {
                result.append(delim);
            }
            result.append(elem);
        }
        return result.toString();
    }

    public static String valueTypeOrNull(Object value) {
        return value == null ? null : value.getClass().getSimpleName();
    }

    public static String schemaTypeOrNull(Schema schema) {
        if (schema == null) {
            return null;
        }
        switch (schema.type()) {
            case STRUCT: {
                return "Struct";
            }
        }
        return schema.type().getName();
    }

    public static boolean isNotBlank(String string) {
        return !Utils.isBlank((String)string);
    }
}

