/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import java.sql.BatchUpdateException;
import java.sql.SQLException;

public class LogUtil {
    public static SQLException trimSensitiveData(SQLException e) {
        return (SQLException)LogUtil.trimSensitiveData((Throwable)e);
    }

    public static Throwable trimSensitiveData(Throwable t) {
        if (!(t instanceof SQLException)) {
            return t;
        }
        if (!(t instanceof BatchUpdateException)) {
            SQLException oldSqe = (SQLException)t;
            SQLException newSqe = new SQLException(oldSqe.getLocalizedMessage());
            newSqe.setNextException(LogUtil.trimSensitiveData(oldSqe.getNextException()));
            return newSqe;
        }
        BatchUpdateException e = (BatchUpdateException)t;
        return new BatchUpdateException(LogUtil.getNonSensitiveErrorMessage(e.getLocalizedMessage()), e.getUpdateCounts());
    }

    private static String getNonSensitiveErrorMessage(String errMsg) {
        String sensitiveStartSearchText = ") VALUES (";
        String errorStartSearchText = ": ERROR: ";
        String errorEndSearchText = "\n  Detail: ";
        if (errMsg == null) {
            return null;
        }
        boolean trimStartIdx = false;
        int trimEndIdx = errMsg.indexOf(") VALUES (");
        if (trimEndIdx < 0) {
            return errMsg;
        }
        String msg1 = errMsg.substring(0, trimEndIdx + 1);
        int errorStartIdx = errMsg.indexOf(": ERROR: ");
        int errorEndIdx = errMsg.indexOf("\n  Detail: ");
        if (errorStartIdx < trimEndIdx || errorEndIdx < trimEndIdx || errorEndIdx < errorStartIdx) {
            return msg1;
        }
        String msg2 = errMsg.substring(errorStartIdx, errorEndIdx);
        return msg1 + msg2;
    }
}

