/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDriverInfo {
    private static final Logger log = LoggerFactory.getLogger(JdbcDriverInfo.class);
    private final int jdbcMajorVersion;
    private final int jdbcMinorVersion;
    private final String jdbcDriverName;
    private final String productName;
    private final String productVersion;

    public JdbcDriverInfo(int jdbcMajorVersion, int jdbcMinorVersion, String jdbcDriverName, String productName, String productVersion) {
        this.jdbcMajorVersion = jdbcMajorVersion;
        this.jdbcMinorVersion = jdbcMinorVersion;
        this.jdbcDriverName = jdbcDriverName;
        this.productName = productName;
        this.productVersion = productVersion;
    }

    public int jdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    public int jdbcMinorVersion() {
        return this.jdbcMinorVersion;
    }

    public String productName() {
        return this.productName;
    }

    public String productVersion() {
        return this.productVersion;
    }

    public String jdbcDriverName() {
        return this.jdbcDriverName;
    }

    public boolean jdbcVersionAtLeast(int jdbcMajorVersion, int jdbcMinorVersion) {
        if (this.jdbcMajorVersion() > jdbcMajorVersion) {
            log.debug("Current JDBC Driver Version {}.{}. The minimum required version {}.{}", new Object[]{this.jdbcMajorVersion(), this.jdbcMinorVersion(), jdbcMajorVersion, jdbcMinorVersion});
            return true;
        }
        if (jdbcMajorVersion == this.jdbcMajorVersion() && this.jdbcMinorVersion() >= jdbcMinorVersion) {
            log.debug("Current JDBC Driver Version is {}.{}. The minimum required version is {}.{}", new Object[]{this.jdbcMajorVersion(), this.jdbcMinorVersion(), jdbcMajorVersion, jdbcMinorVersion});
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.productName() != null) {
            sb.append(this.productName()).append(' ');
        }
        if (this.productVersion() != null) {
            sb.append(this.productVersion()).append(' ');
        }
        if (this.jdbcDriverName() != null) {
            sb.append(" using ").append(this.jdbcDriverName()).append(' ');
        }
        sb.append(this.jdbcMajorVersion()).append('.').append(this.jdbcMinorVersion());
        return sb.toString();
    }
}

