/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.util.ConnectionProvider;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedConnectionProvider
implements ConnectionProvider {
    private static final Logger log = LoggerFactory.getLogger(CachedConnectionProvider.class);
    private static final int VALIDITY_CHECK_TIMEOUT_S = 5;
    private final ConnectionProvider provider;
    private final int maxConnectionAttempts;
    private final long connectionRetryBackoff;
    private int count = 0;
    private Connection connection;
    private volatile boolean isRunning = true;

    public CachedConnectionProvider(ConnectionProvider provider, int maxConnectionAttempts, long connectionRetryBackoff) {
        this.provider = provider;
        this.maxConnectionAttempts = maxConnectionAttempts;
        this.connectionRetryBackoff = connectionRetryBackoff;
    }

    @Override
    public synchronized Connection getConnection() {
        log.debug("Trying to establish connection with the database.");
        try {
            if (this.connection == null) {
                this.newConnection();
            } else if (!this.isConnectionValid(this.connection, 5)) {
                log.info("The database connection is invalid. Reconnecting...");
                this.close();
                this.newConnection();
            }
        }
        catch (SQLException sqle) {
            log.debug("Could not establish connection with database.", (Throwable)sqle);
            throw new ConnectException((Throwable)sqle);
        }
        log.info("Database connection established.");
        return this.connection;
    }

    @Override
    public boolean isConnectionValid(Connection connection, int timeout) {
        try {
            return this.provider.isConnectionValid(connection, timeout);
        }
        catch (SQLException sqle) {
            log.debug("Unable to check if the underlying connection is valid", (Throwable)sqle);
            return false;
        }
    }

    private void newConnection() throws SQLException {
        int attempts = 0;
        while (this.isRunning) {
            try {
                ++this.count;
                log.debug("Attempting to open connection #{} to {}", (Object)this.count, (Object)this.provider);
                this.connection = this.provider.getConnection();
                this.onConnect(this.connection);
                return;
            }
            catch (SQLException sqle) {
                if (this.isRunning && ++attempts < this.maxConnectionAttempts) {
                    log.info("Unable to connect to database on attempt {}/{}. Will retry in {} ms.", new Object[]{attempts, this.maxConnectionAttempts, this.connectionRetryBackoff, sqle});
                    try {
                        Thread.sleep(this.connectionRetryBackoff);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw sqle;
            }
        }
    }

    public void close(boolean stopping) {
        this.isRunning = !stopping;
        this.close();
    }

    @Override
    public synchronized void close() {
        if (this.connection != null) {
            try {
                log.debug("Closing connection #{} to {}", (Object)this.count, (Object)this.provider);
                this.connection.close();
            }
            catch (SQLException sqle) {
                log.warn("Ignoring error closing connection", (Throwable)sqle);
            }
            finally {
                this.connection = null;
                this.provider.close();
            }
        }
    }

    @Override
    public String identifier() {
        return this.provider.identifier();
    }

    protected void onConnect(Connection connection) throws SQLException {
    }
}

