/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.source.JdbcSourceTask;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampIncrementingOffset {
    private static final Logger log = LoggerFactory.getLogger(JdbcSourceTask.class);
    static final String INCREMENTING_FIELD = "incrementing";
    static final String TIMESTAMP_FIELD = "timestamp";
    static final String TIMESTAMP_NANOS_FIELD = "timestamp_nanos";
    private final Long incrementingOffset;
    private final Timestamp timestampOffset;

    public TimestampIncrementingOffset(Timestamp timestampOffset, Long incrementingOffset) {
        this.timestampOffset = timestampOffset;
        this.incrementingOffset = incrementingOffset;
    }

    public long getIncrementingOffset() {
        return this.incrementingOffset == null ? -1L : this.incrementingOffset;
    }

    public Timestamp getTimestampOffset() {
        return this.timestampOffset != null ? this.timestampOffset : new Timestamp(0L);
    }

    public boolean hasTimestampOffset() {
        return this.timestampOffset != null;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (this.incrementingOffset != null) {
            map.put(INCREMENTING_FIELD, this.incrementingOffset);
        }
        if (this.timestampOffset != null) {
            map.put(TIMESTAMP_FIELD, this.timestampOffset.getTime());
            map.put(TIMESTAMP_NANOS_FIELD, this.timestampOffset.getNanos());
        }
        return map;
    }

    public static TimestampIncrementingOffset fromMap(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return new TimestampIncrementingOffset(null, null);
        }
        Long incr = (Long)map.get(INCREMENTING_FIELD);
        Long millis = (Long)map.get(TIMESTAMP_FIELD);
        Timestamp ts = null;
        if (millis != null) {
            log.trace("millis is not null");
            ts = new Timestamp(millis);
            Long nanos = (Long)map.get(TIMESTAMP_NANOS_FIELD);
            if (nanos != null) {
                log.trace("Nanos is not null");
                ts.setNanos(nanos.intValue());
            }
        }
        return new TimestampIncrementingOffset(ts, incr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampIncrementingOffset that = (TimestampIncrementingOffset)o;
        return Objects.equals(this.incrementingOffset, that.incrementingOffset) && Objects.equals(this.timestampOffset, that.timestampOffset);
    }

    public int hashCode() {
        int result = this.incrementingOffset != null ? this.incrementingOffset.hashCode() : 0;
        result = 31 * result + (this.timestampOffset != null ? this.timestampOffset.hashCode() : 0);
        return result;
    }
}

