/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.source.JdbcSourceConnectorConfig;
import io.confluent.connect.jdbc.util.ConfigUtils;
import io.confluent.connect.jdbc.util.DatabaseDialectRecommender;
import io.confluent.connect.jdbc.util.DeleteEnabledRecommender;
import io.confluent.connect.jdbc.util.EnumRecommender;
import io.confluent.connect.jdbc.util.JdbcCredentialsProvider;
import io.confluent.connect.jdbc.util.JdbcCredentialsProviderValidator;
import io.confluent.connect.jdbc.util.PrimaryKeyModeRecommender;
import io.confluent.connect.jdbc.util.QuoteMethod;
import io.confluent.connect.jdbc.util.StringUtils;
import io.confluent.connect.jdbc.util.TableType;
import io.confluent.connect.jdbc.util.TimeZoneValidator;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;

public class JdbcSinkConfig
extends AbstractConfig {
    public static final List<String> DEFAULT_KAFKA_PK_NAMES = Collections.unmodifiableList(Arrays.asList("__connect_topic", "__connect_partition", "__connect_offset"));
    public static final String CONNECTION_URL = "connection.url";
    private static final String CONNECTION_URL_DOC = "JDBC connection URL.\nFor example: ``jdbc:oracle:thin:@localhost:1521:orclpdb1``, ``jdbc:mysql://localhost/db_name``, ``jdbc:sqlserver://localhost;instance=SQLEXPRESS;databaseName=db_name``";
    private static final String CONNECTION_URL_DISPLAY = "JDBC URL";
    public static final String CONNECTION_USER = "connection.user";
    private static final String CONNECTION_USER_DOC = "JDBC connection user.";
    private static final String CONNECTION_USER_DISPLAY = "JDBC User";
    public static final String CONNECTION_PASSWORD = "connection.password";
    private static final String CONNECTION_PASSWORD_DOC = "JDBC connection password.";
    private static final String CONNECTION_PASSWORD_DISPLAY = "JDBC Password";
    public static final String CONNECTION_ATTEMPTS = "connection.attempts";
    private static final String CONNECTION_ATTEMPTS_DOC = "Maximum number of attempts to retrieve a valid JDBC connection. Must be a positive integer.";
    private static final String CONNECTION_ATTEMPTS_DISPLAY = "JDBC connection attempts";
    public static final int CONNECTION_ATTEMPTS_DEFAULT = 3;
    public static final String CONNECTION_BACKOFF = "connection.backoff.ms";
    private static final String CONNECTION_BACKOFF_DOC = "Backoff time in milliseconds between connection attempts.";
    private static final String CONNECTION_BACKOFF_DISPLAY = "JDBC connection backoff in milliseconds";
    public static final long CONNECTION_BACKOFF_DEFAULT = 10000L;
    public static final String TABLE_NAME_FORMAT = "table.name.format";
    private static final String TABLE_NAME_FORMAT_DEFAULT = "${topic}";
    private static final String TABLE_NAME_FORMAT_DOC = "A format string for the destination table name, which may contain '${topic}' as a placeholder for the originating topic name.\nFor example, ``kafka_${topic}`` for the topic 'orders' will map to the table name 'kafka_orders'.";
    private static final String TABLE_NAME_FORMAT_DISPLAY = "Table Name Format";
    public static final String MAX_RETRIES = "max.retries";
    private static final int MAX_RETRIES_DEFAULT = 10;
    private static final String MAX_RETRIES_DOC = "The maximum number of times to retry on errors before failing the task.";
    private static final String MAX_RETRIES_DISPLAY = "Maximum Retries";
    public static final String RETRY_BACKOFF_MS = "retry.backoff.ms";
    private static final int RETRY_BACKOFF_MS_DEFAULT = 3000;
    private static final String RETRY_BACKOFF_MS_DOC = "The time in milliseconds to wait following an error before a retry attempt is made.";
    private static final String RETRY_BACKOFF_MS_DISPLAY = "Retry Backoff (millis)";
    public static final String BATCH_SIZE = "batch.size";
    private static final int BATCH_SIZE_DEFAULT = 3000;
    private static final String BATCH_SIZE_DOC = "Specifies how many records to attempt to batch together for insertion into the destination table, when possible.";
    private static final String BATCH_SIZE_DISPLAY = "Batch Size";
    public static final String DELETE_ENABLED = "delete.enabled";
    private static final String DELETE_ENABLED_DEFAULT = "false";
    private static final String DELETE_ENABLED_DOC = "Whether to treat ``null`` record values as deletes. Requires ``pk.mode`` to be ``record_key``.";
    private static final String DELETE_ENABLED_DISPLAY = "Enable deletes";
    public static final String REPLACE_NULL_WITH_DEFAULT = "replace.null.with.default";
    private static final String REPLACE_NULL_WITH_DEFAULT_DEFAULT = "true";
    private static final String REPLACE_NULL_WITH_DEFAULT_DOC = "Whether to replace ``null`` value with default value";
    private static final String REPLACE_NULL_WITH_DEFAULT_DISPLAY = "Replace null value with default value";
    public static final String AUTO_CREATE = "auto.create";
    private static final String AUTO_CREATE_DEFAULT = "false";
    private static final String AUTO_CREATE_DOC = "Whether to automatically create the destination table based on record schema if it is found to be missing by issuing ``CREATE``.";
    private static final String AUTO_CREATE_DISPLAY = "Auto-Create";
    public static final String AUTO_EVOLVE = "auto.evolve";
    private static final String AUTO_EVOLVE_DEFAULT = "false";
    private static final String AUTO_EVOLVE_DOC = "Whether to automatically add columns in the table schema when found to be missing relative to the record schema by issuing ``ALTER``.";
    private static final String AUTO_EVOLVE_DISPLAY = "Auto-Evolve";
    public static final String INSERT_MODE = "insert.mode";
    private static final String INSERT_MODE_DEFAULT = "insert";
    private static final String INSERT_MODE_DOC = "The insertion mode to use. Supported modes are:\n``insert``\n    Use standard SQL ``INSERT`` statements.\n``upsert``\n    Use the appropriate upsert semantics for the target database if it is supported by the connector, e.g. ``INSERT OR IGNORE``.\n``update``\n    Use the appropriate update semantics for the target database if it is supported by the connector, e.g. ``UPDATE``.";
    private static final String INSERT_MODE_DISPLAY = "Insert Mode";
    public static final String PK_FIELDS = "pk.fields";
    private static final String PK_FIELDS_DEFAULT = "";
    private static final String PK_FIELDS_DOC = "List of comma-separated primary key field names. The runtime interpretation of this config depends on the ``pk.mode``:\n``none``\n    Ignored as no fields are used as primary key in this mode.\n``kafka``\n    Must be a trio representing the Kafka coordinates, defaults to ``" + StringUtils.join(DEFAULT_KAFKA_PK_NAMES, ",") + "`` if empty.\n``record_key``\n    If empty, all fields from the key struct will be used, otherwise used to extract the desired fields - for primitive key only a single field name must be configured.\n``record_value``\n    If empty, all fields from the value struct will be used, otherwise used to extract the desired fields.";
    private static final String PK_FIELDS_DISPLAY = "Primary Key Fields";
    public static final String PK_MODE = "pk.mode";
    private static final String PK_MODE_DEFAULT = "none";
    private static final String PK_MODE_DOC = "The primary key mode, also refer to ``pk.fields`` documentation for interplay. Supported modes are:\n``none``\n    No keys utilized.\n``kafka``\n    Kafka coordinates are used as the PK.\n``record_key``\n    Field(s) from the record key are used, which may be a primitive or a struct.\n``record_value``\n    Field(s) from the record value are used, which must be a struct.";
    private static final String PK_MODE_DISPLAY = "Primary Key Mode";
    public static final String FIELDS_WHITELIST = "fields.whitelist";
    private static final String FIELDS_WHITELIST_DEFAULT = "";
    private static final String FIELDS_WHITELIST_DOC = "List of comma-separated record value field names. If empty, all fields from the record value are utilized, otherwise used to filter to the desired fields.\nNote that ``pk.fields`` is applied independently in the context of which field(s) form the primary key columns in the destination database, while this configuration is applicable for the other columns.";
    private static final String FIELDS_WHITELIST_DISPLAY = "Fields Whitelist";
    private static final ConfigDef.Range NON_NEGATIVE_INT_VALIDATOR = ConfigDef.Range.atLeast((Number)0);
    private static final String CONNECTION_GROUP = "Connection";
    private static final String WRITES_GROUP = "Writes";
    private static final String DATAMAPPING_GROUP = "Data Mapping";
    private static final String DDL_GROUP = "DDL Support";
    private static final String DML_GROUP = "DML Support";
    private static final String RETRIES_GROUP = "Retries";
    public static final String DIALECT_NAME_CONFIG = "dialect.name";
    private static final String DIALECT_NAME_DISPLAY = "Database Dialect";
    public static final String DIALECT_NAME_DEFAULT = "";
    private static final String DIALECT_NAME_DOC = "The name of the database dialect that should be used for this connector. By default this is empty, and the connector automatically determines the dialect based upon the JDBC connection URL. Use this if you want to override that behavior and use a specific dialect. All properly-packaged dialects in the JDBC connector plugin can be used.";
    public static final String DB_TIMEZONE_CONFIG = "db.timezone";
    public static final String DB_TIMEZONE_DEFAULT = "UTC";
    private static final String DB_TIMEZONE_CONFIG_DOC = "Name of the JDBC timezone that should be used in the connector when inserting time-based values. Defaults to UTC.";
    private static final String DB_TIMEZONE_CONFIG_DISPLAY = "DB Time Zone";
    public static final String DATE_TIMEZONE_CONFIG = "date.timezone";
    public static final String DATE_TIMEZONE_DEFAULT = DateTimezone.DB_TIMEZONE.toString();
    private static final String DATE_TIMEZONE_CONFIG_DISPLAY = "Time Zone used for Date";
    private static final String DATE_TIMEZONE_CONFIG_DOC = "Name of the JDBC timezone that should be used in the connector when inserting DATE type values. Defaults to DB_TIMEZONE that uses the timezone set for db.timzeone configuration (to maintain backward compatibility). It is recommended to set this to UTC to avoid conversion for DATE type values.";
    public static final String QUOTE_SQL_IDENTIFIERS_CONFIG = "quote.sql.identifiers";
    public static final String QUOTE_SQL_IDENTIFIERS_DEFAULT = JdbcSourceConnectorConfig.QUOTE_SQL_IDENTIFIERS_DEFAULT;
    public static final String QUOTE_SQL_IDENTIFIERS_DOC = "When to quote table names, column names, and other identifiers in SQL statements. For backward compatibility, the default is ``always``.";
    private static final String QUOTE_SQL_IDENTIFIERS_DISPLAY = "Quote Identifiers";
    public static final String TABLE_TYPES_CONFIG = "table.types";
    private static final String TABLE_TYPES_DISPLAY = "Table Types";
    public static final String TABLE_TYPES_DEFAULT = TableType.TABLE.toString();
    private static final String TABLE_TYPES_DOC = "The comma-separated types of database tables to which the sink connector can write. By default this is ``" + (Object)((Object)TableType.TABLE) + "``, but any combination of ``" + (Object)((Object)TableType.TABLE) + "``, ``" + (Object)((Object)TableType.PARTITIONED_TABLE) + "`` and ``" + (Object)((Object)TableType.VIEW) + "`` is allowed. Not all databases support writing to views, and when they do the sink connector will fail if the view definition does not match the records' schemas (regardless of ``" + "auto.evolve" + "``).";
    public static final String TRIM_SENSITIVE_LOG_ENABLED = "trim.sensitive.log";
    private static final String TRIM_SENSITIVE_LOG_ENABLED_DEFAULT = "false";
    private static final EnumRecommender QUOTE_METHOD_RECOMMENDER = EnumRecommender.in(QuoteMethod.values());
    private static final EnumRecommender DATE_TIMEZONE_RECOMMENDER = EnumRecommender.in(DateTimezone.values());
    private static final EnumRecommender TABLE_TYPES_RECOMMENDER = EnumRecommender.in(TableType.values());
    public static final String MSSQL_USE_MERGE_HOLDLOCK = "mssql.use.merge.holdlock";
    private static final String MSSQL_USE_MERGE_HOLDLOCK_DEFAULT = "true";
    private static final String MSSQL_USE_MERGE_HOLDLOCK_DOC = "Whether to use HOLDLOCK when performing a MERGE INTO upsert statement. Note that it is only applicable to SQL Server.";
    private static final String MSSQL_USE_MERGE_HOLDLOCK_DISPLAY = "SQL Server - Use HOLDLOCK in MERGE";
    public static final String CREDENTIALS_PROVIDER_CONFIG_PREFIX = "jdbc.credentials.provider.";
    public static final String CREDENTIALS_PROVIDER_CLASS_CONFIG = "jdbc.credentials.provider.class";
    public static final Class<? extends JdbcCredentialsProvider> CREDENTIALS_PROVIDER_CLASS_DEFAULT = JdbcSourceConnectorConfig.CREDENTIALS_PROVIDER_CLASS_DEFAULT;
    public static final String CREDENTIALS_PROVIDER_CLASS_DISPLAY = "JDBC Credentials Provider Class";
    public static final String CREDENTIALS_PROVIDER_CLASS_DOC = JdbcSourceConnectorConfig.CREDENTIALS_PROVIDER_CLASS_DOC;
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("connection.url", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, "JDBC connection URL.\nFor example: ``jdbc:oracle:thin:@localhost:1521:orclpdb1``, ``jdbc:mysql://localhost/db_name``, ``jdbc:sqlserver://localhost;instance=SQLEXPRESS;databaseName=db_name``", "Connection", 1, ConfigDef.Width.LONG, "JDBC URL").define("connection.user", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "JDBC connection user.", "Connection", 2, ConfigDef.Width.MEDIUM, "JDBC User").define("connection.password", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, "JDBC connection password.", "Connection", 3, ConfigDef.Width.MEDIUM, "JDBC Password").define("jdbc.credentials.provider.class", ConfigDef.Type.CLASS, CREDENTIALS_PROVIDER_CLASS_DEFAULT, (ConfigDef.Validator)new JdbcCredentialsProviderValidator(), ConfigDef.Importance.LOW, CREDENTIALS_PROVIDER_CLASS_DOC, "Connection", 4, ConfigDef.Width.LONG, "JDBC Credentials Provider Class").define("dialect.name", ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)DatabaseDialectRecommender.INSTANCE, ConfigDef.Importance.LOW, "The name of the database dialect that should be used for this connector. By default this is empty, and the connector automatically determines the dialect based upon the JDBC connection URL. Use this if you want to override that behavior and use a specific dialect. All properly-packaged dialects in the JDBC connector plugin can be used.", "Connection", 5, ConfigDef.Width.LONG, "Database Dialect", (ConfigDef.Recommender)DatabaseDialectRecommender.INSTANCE).define("connection.attempts", ConfigDef.Type.INT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "Maximum number of attempts to retrieve a valid JDBC connection. Must be a positive integer.", "Connection", 6, ConfigDef.Width.SHORT, "JDBC connection attempts").define("connection.backoff.ms", ConfigDef.Type.LONG, (Object)10000L, ConfigDef.Importance.LOW, "Backoff time in milliseconds between connection attempts.", "Connection", 7, ConfigDef.Width.SHORT, "JDBC connection backoff in milliseconds").define("insert.mode", ConfigDef.Type.STRING, (Object)"insert", (ConfigDef.Validator)EnumValidator.in(InsertMode.values()), ConfigDef.Importance.HIGH, "The insertion mode to use. Supported modes are:\n``insert``\n    Use standard SQL ``INSERT`` statements.\n``upsert``\n    Use the appropriate upsert semantics for the target database if it is supported by the connector, e.g. ``INSERT OR IGNORE``.\n``update``\n    Use the appropriate update semantics for the target database if it is supported by the connector, e.g. ``UPDATE``.", "Writes", 1, ConfigDef.Width.MEDIUM, "Insert Mode").define("batch.size", ConfigDef.Type.INT, (Object)3000, (ConfigDef.Validator)NON_NEGATIVE_INT_VALIDATOR, ConfigDef.Importance.MEDIUM, "Specifies how many records to attempt to batch together for insertion into the destination table, when possible.", "Writes", 2, ConfigDef.Width.SHORT, "Batch Size").define("delete.enabled", ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.MEDIUM, "Whether to treat ``null`` record values as deletes. Requires ``pk.mode`` to be ``record_key``.", "Writes", 3, ConfigDef.Width.SHORT, "Enable deletes", (ConfigDef.Recommender)DeleteEnabledRecommender.INSTANCE).define("table.types", ConfigDef.Type.LIST, (Object)TABLE_TYPES_DEFAULT, (ConfigDef.Validator)TABLE_TYPES_RECOMMENDER, ConfigDef.Importance.LOW, TABLE_TYPES_DOC, "Writes", 4, ConfigDef.Width.MEDIUM, "Table Types").define("replace.null.with.default", ConfigDef.Type.BOOLEAN, (Object)"true", ConfigDef.Importance.LOW, "Whether to replace ``null`` value with default value", "Writes", 5, ConfigDef.Width.MEDIUM, "Replace null value with default value").define("table.name.format", ConfigDef.Type.STRING, (Object)"${topic}", (ConfigDef.Validator)new ConfigDef.NonEmptyString(), ConfigDef.Importance.MEDIUM, "A format string for the destination table name, which may contain '${topic}' as a placeholder for the originating topic name.\nFor example, ``kafka_${topic}`` for the topic 'orders' will map to the table name 'kafka_orders'.", "Data Mapping", 1, ConfigDef.Width.LONG, "Table Name Format").define("pk.mode", ConfigDef.Type.STRING, (Object)"none", (ConfigDef.Validator)EnumValidator.in(PrimaryKeyMode.values()), ConfigDef.Importance.HIGH, "The primary key mode, also refer to ``pk.fields`` documentation for interplay. Supported modes are:\n``none``\n    No keys utilized.\n``kafka``\n    Kafka coordinates are used as the PK.\n``record_key``\n    Field(s) from the record key are used, which may be a primitive or a struct.\n``record_value``\n    Field(s) from the record value are used, which must be a struct.", "Data Mapping", 2, ConfigDef.Width.MEDIUM, "Primary Key Mode", (ConfigDef.Recommender)PrimaryKeyModeRecommender.INSTANCE).define("pk.fields", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.MEDIUM, PK_FIELDS_DOC, "Data Mapping", 3, ConfigDef.Width.LONG, "Primary Key Fields").define("fields.whitelist", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.MEDIUM, "List of comma-separated record value field names. If empty, all fields from the record value are utilized, otherwise used to filter to the desired fields.\nNote that ``pk.fields`` is applied independently in the context of which field(s) form the primary key columns in the destination database, while this configuration is applicable for the other columns.", "Data Mapping", 4, ConfigDef.Width.LONG, "Fields Whitelist").define("db.timezone", ConfigDef.Type.STRING, (Object)"UTC", (ConfigDef.Validator)TimeZoneValidator.INSTANCE, ConfigDef.Importance.MEDIUM, "Name of the JDBC timezone that should be used in the connector when inserting time-based values. Defaults to UTC.", "Data Mapping", 5, ConfigDef.Width.MEDIUM, "DB Time Zone").define("date.timezone", ConfigDef.Type.STRING, (Object)DATE_TIMEZONE_DEFAULT, (ConfigDef.Validator)EnumValidator.in(DateTimezone.values()), ConfigDef.Importance.LOW, "Name of the JDBC timezone that should be used in the connector when inserting DATE type values. Defaults to DB_TIMEZONE that uses the timezone set for db.timzeone configuration (to maintain backward compatibility). It is recommended to set this to UTC to avoid conversion for DATE type values.", "Data Mapping", 6, ConfigDef.Width.MEDIUM, "Time Zone used for Date", (ConfigDef.Recommender)DATE_TIMEZONE_RECOMMENDER).define("auto.create", ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.MEDIUM, "Whether to automatically create the destination table based on record schema if it is found to be missing by issuing ``CREATE``.", "DDL Support", 1, ConfigDef.Width.SHORT, "Auto-Create").define("auto.evolve", ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.MEDIUM, "Whether to automatically add columns in the table schema when found to be missing relative to the record schema by issuing ``ALTER``.", "DDL Support", 2, ConfigDef.Width.SHORT, "Auto-Evolve").define("quote.sql.identifiers", ConfigDef.Type.STRING, (Object)QUOTE_SQL_IDENTIFIERS_DEFAULT, ConfigDef.Importance.MEDIUM, "When to quote table names, column names, and other identifiers in SQL statements. For backward compatibility, the default is ``always``.", "DDL Support", 3, ConfigDef.Width.MEDIUM, "Quote Identifiers", (ConfigDef.Recommender)QUOTE_METHOD_RECOMMENDER).define("mssql.use.merge.holdlock", ConfigDef.Type.BOOLEAN, (Object)"true", ConfigDef.Importance.LOW, "Whether to use HOLDLOCK when performing a MERGE INTO upsert statement. Note that it is only applicable to SQL Server.", "DML Support", 1, ConfigDef.Width.MEDIUM, "SQL Server - Use HOLDLOCK in MERGE").define("max.retries", ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)NON_NEGATIVE_INT_VALIDATOR, ConfigDef.Importance.MEDIUM, "The maximum number of times to retry on errors before failing the task.", "Retries", 1, ConfigDef.Width.SHORT, "Maximum Retries").define("retry.backoff.ms", ConfigDef.Type.INT, (Object)3000, (ConfigDef.Validator)NON_NEGATIVE_INT_VALIDATOR, ConfigDef.Importance.MEDIUM, "The time in milliseconds to wait following an error before a retry attempt is made.", "Retries", 2, ConfigDef.Width.SHORT, "Retry Backoff (millis)").defineInternal("trim.sensitive.log", ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.LOW);
    public final String connectorName;
    public final String connectionUrl;
    public final String connectionUser;
    public final String connectionPassword;
    public final int connectionAttempts;
    public final long connectionBackoffMs;
    public final String tableNameFormat;
    public final int batchSize;
    public final boolean deleteEnabled;
    public final boolean replaceNullWithDefault;
    public final int maxRetries;
    public final int retryBackoffMs;
    public final boolean autoCreate;
    public final boolean autoEvolve;
    public final InsertMode insertMode;
    public final PrimaryKeyMode pkMode;
    public final List<String> pkFields;
    public final Set<String> fieldsWhitelist;
    public final String dialectName;
    public final TimeZone timeZone;
    public final TimeZone dateTimeZone;
    public final EnumSet<TableType> tableTypes;
    public final boolean useHoldlockInMerge;
    public final boolean trimSensitiveLogsEnabled;

    public JdbcSinkConfig(Map<?, ?> props) {
        super(CONFIG_DEF, props);
        this.connectorName = ConfigUtils.connectorName(props);
        this.connectionUrl = this.getString(CONNECTION_URL);
        this.connectionUser = this.getString(CONNECTION_USER);
        this.connectionPassword = this.getPasswordValue(CONNECTION_PASSWORD);
        this.connectionAttempts = this.getInt(CONNECTION_ATTEMPTS);
        this.connectionBackoffMs = this.getLong(CONNECTION_BACKOFF);
        this.tableNameFormat = this.getString(TABLE_NAME_FORMAT).trim();
        this.batchSize = this.getInt(BATCH_SIZE);
        this.deleteEnabled = this.getBoolean(DELETE_ENABLED);
        this.replaceNullWithDefault = this.getBoolean(REPLACE_NULL_WITH_DEFAULT);
        this.maxRetries = this.getInt(MAX_RETRIES);
        this.retryBackoffMs = this.getInt(RETRY_BACKOFF_MS);
        this.autoCreate = this.getBoolean(AUTO_CREATE);
        this.autoEvolve = this.getBoolean(AUTO_EVOLVE);
        this.insertMode = InsertMode.valueOf(this.getString(INSERT_MODE).toUpperCase());
        this.pkMode = PrimaryKeyMode.valueOf(this.getString(PK_MODE).toUpperCase());
        this.pkFields = this.getList(PK_FIELDS);
        this.dialectName = this.getString(DIALECT_NAME_CONFIG);
        this.fieldsWhitelist = new HashSet<String>(this.getList(FIELDS_WHITELIST));
        String dbTimeZone = this.getString(DB_TIMEZONE_CONFIG);
        this.timeZone = TimeZone.getTimeZone(ZoneId.of(dbTimeZone));
        DateTimezone dateTimezoneConfig = DateTimezone.valueOf(this.getString(DATE_TIMEZONE_CONFIG).toUpperCase());
        this.dateTimeZone = dateTimezoneConfig.equals((Object)DateTimezone.UTC) ? TimeZone.getTimeZone(ZoneOffset.UTC) : this.timeZone;
        this.useHoldlockInMerge = this.getBoolean(MSSQL_USE_MERGE_HOLDLOCK);
        this.trimSensitiveLogsEnabled = this.getBoolean(TRIM_SENSITIVE_LOG_ENABLED);
        if (this.deleteEnabled && this.pkMode != PrimaryKeyMode.RECORD_KEY) {
            throw new ConfigException("Primary key mode must be 'record_key' when delete support is enabled");
        }
        this.tableTypes = TableType.parse(this.getList(TABLE_TYPES_CONFIG));
    }

    private String getPasswordValue(String key) {
        Password password = this.getPassword(key);
        if (password != null) {
            return password.value();
        }
        return null;
    }

    public String connectorName() {
        return this.connectorName;
    }

    public EnumSet<TableType> tableTypes() {
        return this.tableTypes;
    }

    public Set<String> tableTypeNames() {
        return this.tableTypes().stream().map(TableType::toString).collect(Collectors.toSet());
    }

    public static void main(String ... args) {
        System.out.println(CONFIG_DEF.toEnrichedRst());
    }

    private static class EnumValidator
    implements ConfigDef.Validator {
        private final List<String> canonicalValues;
        private final Set<String> validValues;

        private EnumValidator(List<String> canonicalValues, Set<String> validValues) {
            this.canonicalValues = canonicalValues;
            this.validValues = validValues;
        }

        public static <E> EnumValidator in(E[] enumerators) {
            ArrayList<String> canonicalValues = new ArrayList<String>(enumerators.length);
            HashSet<String> validValues = new HashSet<String>(enumerators.length * 2);
            for (E e : enumerators) {
                canonicalValues.add(e.toString().toLowerCase());
                validValues.add(e.toString().toUpperCase());
                validValues.add(e.toString().toLowerCase());
            }
            return new EnumValidator(canonicalValues, validValues);
        }

        public void ensureValid(String key, Object value) {
            if (!this.validValues.contains(value)) {
                throw new ConfigException(key, value, "Invalid enumerator");
            }
        }

        public String toString() {
            return this.canonicalValues.toString();
        }
    }

    public static enum DateTimezone {
        DB_TIMEZONE,
        UTC;

    }

    public static enum PrimaryKeyMode {
        NONE,
        KAFKA,
        RECORD_KEY,
        RECORD_VALUE;

    }

    public static enum InsertMode {
        INSERT,
        UPSERT,
        UPDATE;

    }
}

