/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc;

import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.JdbcSinkTask;
import io.confluent.connect.jdbc.util.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.sink.SinkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSinkConnector
extends SinkConnector {
    private static final Logger log = LoggerFactory.getLogger(JdbcSinkConnector.class);
    private Map<String, String> configProps;

    public Class<? extends Task> taskClass() {
        return JdbcSinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        log.info("Setting task configurations for {} workers.", (Object)maxTasks);
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>(maxTasks);
        for (int i = 0; i < maxTasks; ++i) {
            configs.add(this.configProps);
        }
        return configs;
    }

    public void start(Map<String, String> props) {
        this.configProps = props;
    }

    public void stop() {
    }

    public ConfigDef config() {
        return JdbcSinkConfig.CONFIG_DEF;
    }

    public Config validate(Map<String, String> connectorConfigs) {
        Config config = super.validate(connectorConfigs);
        return this.validateDeleteEnabledPkMode(config);
    }

    private Config validateDeleteEnabledPkMode(Config config) {
        this.configValue(config, "delete.enabled").filter(deleteEnabled -> Boolean.TRUE.equals(deleteEnabled.value())).ifPresent(deleteEnabled -> this.configValue(config, "pk.mode").ifPresent(pkMode -> {
            if (!JdbcSinkConfig.PrimaryKeyMode.RECORD_KEY.name().toLowerCase(Locale.ROOT).equals(pkMode.value()) && !JdbcSinkConfig.PrimaryKeyMode.RECORD_KEY.name().toUpperCase(Locale.ROOT).equals(pkMode.value())) {
                String conflictMsg = "Deletes are only supported for pk.mode record_key";
                pkMode.addErrorMessage(conflictMsg);
                deleteEnabled.addErrorMessage(conflictMsg);
            }
        }));
        return config;
    }

    private Optional<ConfigValue> configValue(Config config, String name) {
        return config.configValues().stream().filter(cfg -> name.equals(cfg.name()) && cfg.errorMessages().isEmpty()).findFirst();
    }

    public String version() {
        return Version.getVersion();
    }
}

