/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.aggregation.AggregationFunction;
import org.apache.flink.api.java.aggregation.AggregationFunctionFactory;
import org.apache.flink.api.java.aggregation.UnsupportedAggregationTypeException;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.ResettableValue;

@Internal
public abstract class MaxAggregationFunction<T extends Comparable<T>>
extends AggregationFunction<T> {
    private static final long serialVersionUID = 1L;

    public String toString() {
        return "MAX";
    }

    public static final class MaxAggregationFunctionFactory
    implements AggregationFunctionFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public <T> AggregationFunction<T> createAggregationFunction(Class<T> type) {
            if (Comparable.class.isAssignableFrom(type)) {
                if (ResettableValue.class.isAssignableFrom(type) && CopyableValue.class.isAssignableFrom(type)) {
                    return new MutableMaxAgg();
                }
                return new ImmutableMaxAgg();
            }
            throw new UnsupportedAggregationTypeException("The type " + type.getName() + " is not supported for maximum aggregation. Maximum aggregatable types must implement the Comparable interface.");
        }
    }

    private static final class MutableMaxAgg<U extends Comparable<U> & ResettableValue<U>>
    extends MaxAggregationFunction<U> {
        private static final long serialVersionUID = 1L;
        private U value;

        private MutableMaxAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.value = null;
        }

        @Override
        public void aggregate(U val) {
            if (this.value != null) {
                int cmp = this.value.compareTo(val);
                if (cmp < 0) {
                    ((ResettableValue)this.value).setValue(val);
                }
            } else {
                this.value = (Comparable)((CopyableValue)val).copy();
            }
        }

        @Override
        public U getAggregate() {
            return this.value;
        }
    }

    private static final class ImmutableMaxAgg<U extends Comparable<U>>
    extends MaxAggregationFunction<U> {
        private static final long serialVersionUID = 1L;
        private U value;

        private ImmutableMaxAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.value = null;
        }

        @Override
        public void aggregate(U val) {
            int cmp;
            this.value = this.value != null ? ((cmp = this.value.compareTo(val)) > 0 ? this.value : val) : val;
        }

        @Override
        public U getAggregate() {
            return this.value;
        }
    }
}

