/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.license.trial;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import kafka.utils.ZkUtils;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkTrialPeriod {
    private static final Logger log = LoggerFactory.getLogger(ZkTrialPeriod.class);
    private static final String DEFAULT_TRIAL_PERIOD_ZK_PATH = "/confluent-license/trial";
    private static final int ZK_SESSION_TIMEOUT_MS = 30000;
    private static final int ZK_CONNECT_TIMEOUT_MS = 7000;
    private static final long TRIAL_LIMIT_MS = TimeUnit.DAYS.toMillis(30L);
    private final String licensePath;
    private final String zkConnect;

    public ZkTrialPeriod(String zkConnect) {
        this(zkConnect, DEFAULT_TRIAL_PERIOD_ZK_PATH);
    }

    public ZkTrialPeriod(String zkConnect, String licensePath) {
        this.zkConnect = zkConnect;
        this.licensePath = licensePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startOrVerify(long now) {
        try (ZkUtils zkUtils = ZkUtils.apply((String)this.zkConnect, (int)30000, (int)7000, (boolean)JaasUtils.isZkSecurityEnabled());){
            long l = this.startOrVerifyTrial(zkUtils, now);
            return l;
        }
    }

    private long startOrVerifyTrial(ZkUtils zkUtils, long now) {
        try {
            zkUtils.createPersistentPath(this.licensePath, "", zkUtils.defaultAcls(this.licensePath));
            log.info("Registered trial license with a validity period of {} days", (Object)TimeUnit.MILLISECONDS.toDays(TRIAL_LIMIT_MS));
            return TRIAL_LIMIT_MS;
        }
        catch (ZkNodeExistsException e) {
            log.debug("Trial period has already started, checking elapsed time");
            Stat stat = (Stat)zkUtils.readData((String)this.licensePath)._2;
            long trialStartTimeMs = stat.getCtime();
            long elapsedTime = Math.max(now - trialStartTimeMs, 0L);
            long remainingMs = Math.max(TRIAL_LIMIT_MS - elapsedTime, 0L);
            Date trialStartDate = new Date(trialStartTimeMs);
            if (remainingMs == 0L) {
                log.error("Your trial license registered at {} has expired. Please add a valid license to continue using the product", (Object)trialStartDate);
            } else {
                log.info("Using trial license registered at {} which expires in {} seconds", (Object)trialStartDate, (Object)TimeUnit.MILLISECONDS.toSeconds(remainingMs));
            }
            return remainingMs;
        }
    }
}

