/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.server;

import io.bootique.jetty.server.ServerHolder;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerLifecycleLogger
extends AbstractLifeCycle.AbstractLifeCycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerLifecycleLogger.class);
    private ServerHolder serverHolder;
    private long t0;

    public ServerLifecycleLogger(ServerHolder serverHolder) {
        this.serverHolder = serverHolder;
    }

    public void lifeCycleStarting(LifeCycle event) {
        this.t0 = System.currentTimeMillis();
        LOGGER.info("Starting jetty...");
    }

    public void lifeCycleStarted(LifeCycle event) {
        long time = System.currentTimeMillis() - this.t0;
        switch (this.serverHolder.getConnectorsCount()) {
            case 0: {
                LOGGER.info("Started Jetty in {} ms. No connectors configured", (Object)time);
                return;
            }
            case 1: {
                LOGGER.info("Started Jetty in {} ms. Base URL: {}", (Object)time, (Object)this.serverHolder.getUrl());
                return;
            }
        }
        LOGGER.info("Started Jetty in {} ms. Base URLs: {}", (Object)time, (Object)this.serverHolder.getUrls().collect(Collectors.joining(", ")));
    }
}

