/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.server;

import io.bootique.jetty.MappedFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebInitParam;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class MappedFilterFactory {
    public MappedFilter toMappedFilter(Filter filter, int order) {
        WebFilter wfAnnotation = filter.getClass().getAnnotation(WebFilter.class);
        if (wfAnnotation == null) {
            throw new IllegalArgumentException("Filter contains no @WebFilter annotation and can not be mapped directly. Wrap it in a MappedFilter instead.");
        }
        String name = wfAnnotation.filterName() != null && wfAnnotation.filterName().length() > 0 ? wfAnnotation.filterName() : null;
        HashSet<String> urlPatterns = new HashSet<String>(Arrays.asList(wfAnnotation.urlPatterns()));
        HashMap<String, String> initParams = new HashMap<String, String>();
        WebInitParam[] paramsArray = wfAnnotation.initParams();
        if (paramsArray != null) {
            Arrays.asList(paramsArray).forEach(p -> initParams.put(p.name(), p.value()));
        }
        return new MappedFilter<Filter>(filter, urlPatterns, name, initParams, order);
    }
}

