/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.connector;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import javax.net.ServerSocketFactory;

public class PortFinder {
    static final int MIN_PORT = 1024;
    static final int MAX_PORT = 65535;

    public static int findAvailablePort(String host) {
        return PortFinder.findAvailablePort(host, 1024, 65535);
    }

    public static int findAvailablePort(String host, int minPort, int maxPort) {
        if (minPort <= 0) {
            throw new IllegalArgumentException("Illegal min port: " + minPort);
        }
        if (maxPort <= 0) {
            throw new IllegalArgumentException("Illegal max port: " + minPort);
        }
        if (minPort > maxPort) {
            throw new IllegalArgumentException("Min port must be <= than max port: " + minPort + ", " + maxPort);
        }
        Random rnd = new Random();
        InetAddress hostAddress = PortFinder.resolveHost(host);
        int portRange = maxPort - minPort + 1;
        for (int i = 0; i < 10000; ++i) {
            int port = minPort + rnd.nextInt(portRange);
            if (!PortFinder.isPortAvailable(port, hostAddress)) continue;
            return port;
        }
        throw new RuntimeException("Failed to find an available TCP port between " + minPort + " and " + maxPort);
    }

    static InetAddress resolveHost(String host) {
        String hostname = host != null && !host.isEmpty() ? host : "127.0.0.1";
        try {
            return InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Error resolving localhost", e);
        }
    }

    static boolean isPortAvailable(int port, InetAddress localhost) {
        try {
            ServerSocketFactory.getDefault().createServerSocket(port, 1, localhost).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

