/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.command;

import io.bootique.cli.Cli;
import io.bootique.command.CommandOutcome;
import io.bootique.command.CommandWithMetadata;
import io.bootique.meta.application.CommandMetadata;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.jetty.server.Server;

public class ServerCommand
extends CommandWithMetadata {
    private Provider<Server> serverProvider;

    @Inject
    public ServerCommand(Provider<Server> serverProvider) {
        super(ServerCommand.createMetadata());
        this.serverProvider = serverProvider;
    }

    private static CommandMetadata createMetadata() {
        return CommandMetadata.builder(ServerCommand.class).description("Starts Jetty server.").build();
    }

    public CommandOutcome run(Cli cli) {
        Server server = (Server)this.serverProvider.get();
        try {
            server.start();
        }
        catch (Exception e) {
            return CommandOutcome.failed((int)1, (Throwable)e);
        }
        return CommandOutcome.succeededAndForkedToBackground();
    }
}

