/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty;

import io.bootique.BQCoreModule;
import io.bootique.ModuleExtender;
import io.bootique.di.Binder;
import io.bootique.di.Key;
import io.bootique.di.MapBuilder;
import io.bootique.di.SetBuilder;
import io.bootique.di.TypeLiteral;
import io.bootique.jetty.MappedFilter;
import io.bootique.jetty.MappedListener;
import io.bootique.jetty.MappedServlet;
import io.bootique.jetty.request.RequestMDCItem;
import io.bootique.jetty.server.ServletContextHandlerExtender;
import io.bootique.jetty.servlet.MultiBaseStaticServlet;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;

public class JettyModuleExtender
extends ModuleExtender<JettyModuleExtender> {
    private SetBuilder<Filter> filters;
    private SetBuilder<Servlet> servlets;
    private SetBuilder<EventListener> listeners;
    private SetBuilder<MappedFilter> mappedFilters;
    private SetBuilder<MappedServlet> mappedServlets;
    private SetBuilder<MappedListener> mappedListeners;
    private MapBuilder<String, RequestMDCItem> mdcItems;
    private SetBuilder<ServletContextHandlerExtender> contextHandlerExtenders;

    public JettyModuleExtender(Binder binder) {
        super(binder);
    }

    public JettyModuleExtender initAllExtensions() {
        this.contributeFilters();
        this.contributeServlets();
        this.contributeListeners();
        this.contributeMappedFilters();
        this.contributeMappedServlets();
        this.contributeMappedListeners();
        this.contributeContextHandlerExtenders();
        this.contributeMdcItems();
        return this;
    }

    public JettyModuleExtender addRequestMDCItem(String mdcKey, RequestMDCItem item) {
        this.contributeMdcItems().putInstance((Object)mdcKey, (Object)item);
        return this;
    }

    public JettyModuleExtender addRequestMDCItem(String mdcKey, Class<? extends RequestMDCItem> itemType) {
        this.contributeMdcItems().put((Object)mdcKey, itemType);
        return this;
    }

    public JettyModuleExtender addListener(EventListener listener) {
        this.contributeListeners().addInstance((Object)listener);
        return this;
    }

    public JettyModuleExtender addListener(Class<? extends EventListener> listenerType) {
        this.contributeListeners().add(listenerType);
        return this;
    }

    public <T extends EventListener> JettyModuleExtender addMappedListener(MappedListener<T> mappedListener) {
        this.contributeMappedListeners().addInstance(mappedListener);
        return this;
    }

    public <T extends EventListener> JettyModuleExtender addMappedListener(Key<MappedListener<T>> mappedListenerKey) {
        this.contributeMappedListeners().add(mappedListenerKey);
        return this;
    }

    public <T extends EventListener> JettyModuleExtender addMappedListener(TypeLiteral<MappedListener<T>> mappedListenerType) {
        return this.addMappedListener(Key.get(mappedListenerType));
    }

    public JettyModuleExtender addStaticServlet(String name, String ... urlPatterns) {
        return this.addServlet((Servlet)new MultiBaseStaticServlet(), name, urlPatterns);
    }

    public JettyModuleExtender useDefaultServlet() {
        return this.addStaticServlet("default", "/");
    }

    public JettyModuleExtender setServletParam(String servletName, String propertyName, String propertyValue) {
        BQCoreModule.extend((Binder)this.binder).setProperty("bq.jetty.servlets." + servletName + ".params." + propertyName, propertyValue);
        return this;
    }

    public JettyModuleExtender addServlet(Class<? extends Servlet> servletType) {
        this.contributeServlets().add(servletType);
        return this;
    }

    public JettyModuleExtender addServlet(Servlet servlet, String name, String ... urlPatterns) {
        HashSet<String> urlPatternsSet = new HashSet<String>();
        if (urlPatterns != null) {
            Collections.addAll(urlPatternsSet, urlPatterns);
        }
        return this.addMappedServlet(new MappedServlet<Servlet>(servlet, urlPatternsSet, name));
    }

    public <T extends Servlet> JettyModuleExtender addMappedServlet(MappedServlet<T> mappedServlet) {
        this.contributeMappedServlets().addInstance(mappedServlet);
        return this;
    }

    public <T extends Servlet> JettyModuleExtender addMappedServlet(Key<MappedServlet<T>> mappedServletKey) {
        this.contributeMappedServlets().add(mappedServletKey);
        return this;
    }

    public <T extends Servlet> JettyModuleExtender addMappedServlet(TypeLiteral<MappedServlet<T>> mappedServletType) {
        return this.addMappedServlet(Key.get(mappedServletType));
    }

    public JettyModuleExtender addFilter(Class<? extends Filter> filterType) {
        this.contributeFilters().add(filterType);
        return this;
    }

    public JettyModuleExtender addFilter(Filter filter, String name, int order, String ... urlPatterns) {
        HashSet<String> urlPatternsSet = new HashSet<String>();
        if (urlPatterns != null) {
            Collections.addAll(urlPatternsSet, urlPatterns);
        }
        return this.addMappedFilter(new MappedFilter<Filter>(filter, urlPatternsSet, name, order));
    }

    public <T extends Filter> JettyModuleExtender addMappedFilter(MappedFilter<T> mappedFilter) {
        this.contributeMappedFilters().addInstance(mappedFilter);
        return this;
    }

    public <T extends Filter> JettyModuleExtender addMappedFilter(Key<MappedFilter<T>> mappedFilterKey) {
        this.contributeMappedFilters().add(mappedFilterKey);
        return this;
    }

    public <T extends Filter> JettyModuleExtender addMappedFilter(TypeLiteral<MappedFilter<T>> mappedFilterType) {
        return this.addMappedFilter(Key.get(mappedFilterType));
    }

    public JettyModuleExtender addContextHandlerExtender(ServletContextHandlerExtender extender) {
        this.contributeContextHandlerExtenders().addInstance((Object)extender);
        return this;
    }

    public JettyModuleExtender addContextHandlerExtender(Class<? extends ServletContextHandlerExtender> type) {
        this.contributeContextHandlerExtenders().add(type);
        return this;
    }

    protected SetBuilder<Filter> contributeFilters() {
        return this.filters != null ? this.filters : (this.filters = this.newSet(Filter.class));
    }

    protected SetBuilder<Servlet> contributeServlets() {
        return this.servlets != null ? this.servlets : (this.servlets = this.newSet(Servlet.class));
    }

    protected SetBuilder<EventListener> contributeListeners() {
        return this.listeners != null ? this.listeners : (this.listeners = this.newSet(EventListener.class));
    }

    protected SetBuilder<MappedFilter> contributeMappedFilters() {
        return this.mappedFilters != null ? this.mappedFilters : (this.mappedFilters = this.newSet(MappedFilter.class));
    }

    protected SetBuilder<MappedServlet> contributeMappedServlets() {
        return this.mappedServlets != null ? this.mappedServlets : (this.mappedServlets = this.newSet(MappedServlet.class));
    }

    protected SetBuilder<MappedListener> contributeMappedListeners() {
        return this.mappedListeners != null ? this.mappedListeners : (this.mappedListeners = this.newSet(MappedListener.class));
    }

    protected MapBuilder<String, RequestMDCItem> contributeMdcItems() {
        return this.mdcItems != null ? this.mdcItems : (this.mdcItems = this.newMap(String.class, RequestMDCItem.class));
    }

    protected SetBuilder<ServletContextHandlerExtender> contributeContextHandlerExtenders() {
        return this.contextHandlerExtenders != null ? this.contextHandlerExtenders : (this.contextHandlerExtenders = this.newSet(ServletContextHandlerExtender.class));
    }
}

