/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jdbc.hikaricp;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.di.Injector;
import io.bootique.jdbc.managed.ManagedDataSourceFactory;
import io.bootique.jdbc.managed.ManagedDataSourceStarter;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BQConfig(value="Pooling Hikari JDBC DataSource configuration.")
@JsonTypeName(value="hikari")
public class HikariCPManagedDataSourceFactory
implements ManagedDataSourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariCPManagedDataSourceFactory.class);
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final long VALIDATION_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final long IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private boolean allowPoolSuspension;
    private boolean autoCommit = true;
    private String catalog;
    private String connectionInitSql;
    private String connectionTestQuery;
    private long connectionTimeout;
    private String dataSourceClassName;
    private String dataSourceJNDI;
    private Properties dataSourceProperties = new Properties();
    private String driverClassName;
    private long idleTimeout;
    private long initializationFailTimeout = 1L;
    private boolean isolateInternalQueries;
    private String jdbcUrl;
    private long leakDetectionThreshold;
    private long maxLifetime = MAX_LIFETIME;
    private int maximumPoolSize = 100;
    private int minimumIdle = 10;
    private String password;
    private String schema;
    private String transactionIsolationName;
    private boolean readOnly;
    private boolean registerMbeans;
    private String username;
    private long validationTimeout;

    public HikariCPManagedDataSourceFactory() {
        this.connectionTimeout = CONNECTION_TIMEOUT;
        this.validationTimeout = VALIDATION_TIMEOUT;
        this.idleTimeout = IDLE_TIMEOUT;
    }

    public ManagedDataSourceStarter create(String dataSourceName, Injector injector) {
        Supplier<DataSource> startup = () -> {
            this.validate();
            LOGGER.info("Starting Hikari DataSource: {}", (Object)this.jdbcUrl);
            return new HikariDataSource(this.toConfiguration(dataSourceName));
        };
        Consumer<DataSource> shutdown = ds -> ((HikariDataSource)ds).close();
        return this.create(dataSourceName, injector, startup, shutdown);
    }

    protected ManagedDataSourceStarter create(String dataSourceName, Injector injector, Supplier<DataSource> startup, Consumer<DataSource> shutdown) {
        String url = this.getJdbcUrl();
        return new ManagedDataSourceStarter(() -> url, startup, shutdown);
    }

    protected void validate() {
        Objects.requireNonNull(this.jdbcUrl, "'jdbcUrl' property should not be null");
    }

    @BQConfigProperty
    public void setConnectionTimeout(long connectionTimeoutMs) {
        if (connectionTimeoutMs == 0L) {
            this.connectionTimeout = Integer.MAX_VALUE;
        } else {
            if (connectionTimeoutMs < 250L) {
                throw new IllegalArgumentException("connectionTimeout cannot be less than 250ms");
            }
            this.connectionTimeout = connectionTimeoutMs;
        }
    }

    @BQConfigProperty
    public void setIdleTimeout(long idleTimeoutMs) {
        if (idleTimeoutMs < 0L) {
            throw new IllegalArgumentException("idleTimeout cannot be negative");
        }
        this.idleTimeout = idleTimeoutMs;
    }

    @BQConfigProperty
    public void setLeakDetectionThreshold(long leakDetectionThresholdMs) {
        this.leakDetectionThreshold = leakDetectionThresholdMs;
    }

    @BQConfigProperty
    public void setMaxLifetime(long maxLifetimeMs) {
        this.maxLifetime = maxLifetimeMs;
    }

    @BQConfigProperty
    public void setMaximumPoolSize(int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("'maximumPoolSize' cannot be less than 1");
        }
        this.maximumPoolSize = maxPoolSize;
    }

    @BQConfigProperty
    public void setMinimumIdle(int minIdle) {
        if (minIdle < 0) {
            throw new IllegalArgumentException("'minimumIdle' cannot be negative");
        }
        this.minimumIdle = minIdle;
    }

    @BQConfigProperty
    public void setPassword(String password) {
        this.password = password;
    }

    @BQConfigProperty
    public void setUsername(String username) {
        this.username = username;
    }

    @BQConfigProperty
    public void setValidationTimeout(long validationTimeoutMs) {
        if (validationTimeoutMs < 250L) {
            throw new IllegalArgumentException("'validationTimeout' cannot be less than 250ms");
        }
        this.validationTimeout = validationTimeoutMs;
    }

    @BQConfigProperty
    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    @BQConfigProperty
    public void setConnectionTestQuery(String connectionTestQuery) {
        this.connectionTestQuery = connectionTestQuery;
    }

    @BQConfigProperty
    public void setConnectionInitSql(String connectionInitSql) {
        this.connectionInitSql = connectionInitSql;
    }

    @BQConfigProperty
    public void setDataSourceClassName(String className) {
        this.dataSourceClassName = className;
    }

    @BQConfigProperty
    public void setDataSourceJNDI(String dataSourceJNDI) {
        this.dataSourceJNDI = dataSourceJNDI;
    }

    @BQConfigProperty
    public void setDataSourceProperties(Properties dsProperties) {
        this.dataSourceProperties.putAll((Map<?, ?>)dsProperties);
    }

    @BQConfigProperty
    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @BQConfigProperty
    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    @BQConfigProperty
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @BQConfigProperty
    public void setAllowPoolSuspension(boolean allowPoolSuspension) {
        this.allowPoolSuspension = allowPoolSuspension;
    }

    @BQConfigProperty
    public void setInitializationFailTimeout(long initializationFailTimeout) {
        this.initializationFailTimeout = initializationFailTimeout;
    }

    @BQConfigProperty
    public void setIsolateInternalQueries(boolean isolate) {
        this.isolateInternalQueries = isolate;
    }

    @BQConfigProperty
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @BQConfigProperty
    public void setRegisterMbeans(boolean register) {
        this.registerMbeans = register;
    }

    @BQConfigProperty
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @BQConfigProperty
    public void setTransactionIsolation(String isolationLevel) {
        this.transactionIsolationName = isolationLevel;
    }

    protected HikariConfig toConfiguration(String dataSourceName) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setPoolName(dataSourceName);
        hikariConfig.setConnectionTimeout(this.connectionTimeout);
        hikariConfig.setValidationTimeout(this.validationTimeout);
        hikariConfig.setIdleTimeout(this.idleTimeout);
        hikariConfig.setLeakDetectionThreshold(this.leakDetectionThreshold);
        hikariConfig.setMaxLifetime(this.maxLifetime);
        hikariConfig.setMaximumPoolSize(this.maximumPoolSize);
        hikariConfig.setMinimumIdle(this.minimumIdle);
        hikariConfig.setUsername(this.username);
        hikariConfig.setPassword(this.password);
        hikariConfig.setInitializationFailTimeout(this.initializationFailTimeout);
        hikariConfig.setCatalog(this.catalog);
        hikariConfig.setConnectionInitSql(this.connectionInitSql);
        hikariConfig.setConnectionTestQuery(this.connectionTestQuery);
        hikariConfig.setDataSourceClassName(this.dataSourceClassName);
        hikariConfig.setDataSourceJNDI(this.dataSourceJNDI);
        if (this.driverClassName != null) {
            hikariConfig.setDriverClassName(this.driverClassName);
        }
        hikariConfig.setJdbcUrl(this.jdbcUrl);
        hikariConfig.setSchema(this.schema);
        hikariConfig.setTransactionIsolation(this.transactionIsolationName);
        hikariConfig.setAutoCommit(this.autoCommit);
        hikariConfig.setReadOnly(this.readOnly);
        hikariConfig.setIsolateInternalQueries(this.isolateInternalQueries);
        hikariConfig.setRegisterMbeans(this.registerMbeans);
        hikariConfig.setAllowPoolSuspension(this.allowPoolSuspension);
        hikariConfig.setDataSourceProperties(this.dataSourceProperties);
        hikariConfig.setThreadFactory((ThreadFactory)new HikariThreadFactory());
        return hikariConfig;
    }

    private static class HikariThreadFactory
    implements ThreadFactory {
        private AtomicInteger counter = new AtomicInteger();

        private HikariThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("bootique-hikari-" + this.counter.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

