/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.Key;
import io.bootique.di.spi.DefaultInjector;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Provider;

class SetProvider<T>
implements Provider<Set<T>> {
    private final DefaultInjector injector;
    private final Collection<Provider<? extends T>> providers;
    private final Key<Set<T>> bindingKey;

    SetProvider(DefaultInjector injector, Key<Set<T>> bindingKey) {
        this.injector = injector;
        this.providers = new ConcurrentLinkedQueue<Provider<? extends T>>();
        this.bindingKey = bindingKey;
    }

    public Set<T> get() {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>(this.providers.size());
        int i = 0;
        for (Provider<? extends T> provider : this.providers) {
            int idx = i++;
            this.injector.trace(() -> "Resolving set element " + idx);
            Object value = provider.get();
            if (set.add(value)) continue;
            this.injector.throwException("Found duplicated value '%s' in set %s.", value, this.bindingKey);
        }
        return set;
    }

    void add(Provider<? extends T> provider) {
        this.providers.add(provider);
    }
}

