/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.spi.DefaultInjector;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;

class MapProvider<K, V>
implements Provider<Map<K, V>> {
    private final Map<K, Provider<? extends V>> providers = new ConcurrentHashMap<K, Provider<? extends V>>();
    private final DefaultInjector injector;

    MapProvider(DefaultInjector injector) {
        this.injector = injector;
    }

    public Map<K, V> get() {
        HashMap<K, Object> map = new HashMap<K, Object>();
        for (Map.Entry entry : this.providers.entrySet()) {
            this.injector.trace(() -> "Resolve map key '" + entry.getKey() + "'");
            map.put(entry.getKey(), entry.getValue().get());
        }
        return map;
    }

    void put(K key, Provider<? extends V> provider) {
        this.providers.put(key, provider);
    }
}

