/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.BQInject;
import io.bootique.di.DIRuntimeException;
import io.bootique.di.Provides;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Qualifier;
import javax.inject.Singleton;

public class InjectorPredicates {
    private Predicate<AccessibleObject> injectPredicate = o -> o.isAnnotationPresent(Inject.class) || o.isAnnotationPresent(BQInject.class);
    private Predicate<Method> providesMethodPredicate = m -> m.isAnnotationPresent(Provides.class);
    private Predicate<AnnotatedElement> singletonPredicate = o -> o.isAnnotationPresent(Singleton.class);
    private Predicate<Class<? extends Annotation>> qualifierPredicate = c -> c.isAnnotationPresent(Qualifier.class);
    private Predicate<Type> providerPredicate = Provider.class::equals;
    private Function<Provider<?>, Provider<?>> providerFunction = Function.identity();
    private ExceptionProvider<?> exceptionProvider = DIRuntimeException::new;

    public void setInjectPredicate(Predicate<AccessibleObject> injectPredicate) {
        this.injectPredicate = injectPredicate;
    }

    public void setProviderPredicate(Predicate<Type> providerPredicate) {
        this.providerPredicate = providerPredicate;
    }

    public void setProvidesMethodPredicate(Predicate<Method> providesMethodPredicate) {
        this.providesMethodPredicate = providesMethodPredicate;
    }

    public void setQualifierPredicate(Predicate<Class<? extends Annotation>> qualifierPredicate) {
        this.qualifierPredicate = qualifierPredicate;
    }

    public void setSingletonPredicate(Predicate<AnnotatedElement> singletonPredicate) {
        this.singletonPredicate = singletonPredicate;
    }

    public <T> void setProviderFunction(Function<Provider<T>, Provider<T>> providerFunction) {
        this.providerFunction = providerFunction;
    }

    public void setExceptionProvider(ExceptionProvider<?> exceptionProvider) {
        this.exceptionProvider = exceptionProvider;
    }

    boolean isSingleton(AnnotatedElement object) {
        return this.singletonPredicate.test(object);
    }

    boolean hasInjectAnnotation(AccessibleObject object) {
        return this.injectPredicate.test(object);
    }

    boolean isProviderMethod(Method method) {
        return this.providesMethodPredicate.test(method);
    }

    boolean isQualifierAnnotation(Annotation annotation) {
        return this.qualifierPredicate.test(annotation.annotationType());
    }

    boolean isProviderType(Type type) {
        return this.providerPredicate.test(type);
    }

    <T> Provider<T> wrapProvider(Provider<T> provider) {
        return this.providerFunction.apply(provider);
    }

    Predicate<Method> getProvidesMethodPredicate() {
        return this.providesMethodPredicate;
    }

    Predicate<AccessibleObject> getInjectPredicate() {
        return this.injectPredicate;
    }

    Predicate<Class<? extends Annotation>> getQualifierPredicate() {
        return this.qualifierPredicate;
    }

    DIRuntimeException createException(String message, Object ... args) {
        return this.createException(message, null, args);
    }

    DIRuntimeException createException(String message, Throwable cause, Object ... args) {
        return this.exceptionProvider.newException(message, cause, args);
    }

    @FunctionalInterface
    public static interface ExceptionProvider<T extends DIRuntimeException> {
        public T newException(String var1, Throwable var2, Object ... var3);
    }
}

