/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.TypeLiteral;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class GenericTypesUtils {
    static Type getGenericParameterType(Type type) {
        ParameterizedType parameterizedType;
        Type[] parameters;
        if (type instanceof ParameterizedType && (parameters = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return parameters[0];
        }
        return null;
    }

    static Class<?> parameterClass(Type type) {
        Type parameterType = GenericTypesUtils.getGenericParameterType(type);
        if (parameterType == null) {
            return null;
        }
        return GenericTypesUtils.typeToClass(parameterType);
    }

    private static Class<?> typeToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return Object.class;
    }

    static TypeLiteral<?> resolveVariableType(Class<?> objectClass, Field field, Type variableType) {
        Class<?> declaringClass = field.getDeclaringClass();
        Type genericSuperclass = GenericTypesUtils.getSuperclassDeclaringField(objectClass, declaringClass);
        if (genericSuperclass == null) {
            return null;
        }
        int idx = GenericTypesUtils.getTypeVariableIdx(variableType.getTypeName(), declaringClass);
        if (idx == -1) {
            return null;
        }
        ParameterizedType parameterizedSuperType = (ParameterizedType)genericSuperclass;
        parameterizedSuperType.getRawType();
        Type actualType = parameterizedSuperType.getActualTypeArguments()[idx];
        return TypeLiteral.of(actualType);
    }

    private static Type getSuperclassDeclaringField(Class<?> objectClass, Class<?> declaringClass) {
        while (objectClass.getSuperclass() != null && !objectClass.getSuperclass().equals(declaringClass)) {
            objectClass = objectClass.getSuperclass();
        }
        Type genericSuperclass = objectClass.getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            return null;
        }
        return genericSuperclass;
    }

    private static int getTypeVariableIdx(String typeVariableName, Class<?> declaringClass) {
        int idx;
        TypeVariable<Class<?>>[] typeParameters = declaringClass.getTypeParameters();
        for (idx = 0; idx < typeParameters.length && !typeParameters[idx].getName().equals(typeVariableName); ++idx) {
        }
        if (idx == typeParameters.length) {
            return -1;
        }
        return idx;
    }
}

