/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.Key;
import io.bootique.di.TypeLiteral;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.GenericTypesUtils;
import io.bootique.di.spi.MemberInjectingProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.function.Predicate;
import javax.inject.Provider;

class FieldInjectingProvider<T>
extends MemberInjectingProvider<T> {
    FieldInjectingProvider(Provider<T> delegate, DefaultInjector injector) {
        super(delegate, injector);
    }

    @Override
    protected void injectMembers(T object, Class<?> type) {
        if (type == Object.class) {
            return;
        }
        this.injectMembers(object, type.getSuperclass());
        Predicate<AccessibleObject> injectPredicate = this.injector.getPredicates().getInjectPredicate();
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || !injectPredicate.test(field)) continue;
            this.injectMember(object, field, this.getQualifier(field));
        }
    }

    private void injectMember(Object object, Field field, Annotation bindingAnnotation) {
        this.injector.trace(() -> "Injecting field '" + field.getName() + "' of class " + field.getDeclaringClass().getName());
        TypeLiteral<?> fieldType = this.getFieldType(object, field);
        Object value = this.value(field, fieldType, bindingAnnotation);
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (Exception e) {
            this.injector.throwException("Error injecting into field %s.%s of type %s", e, field.getDeclaringClass().getName(), field.getName(), field.getType().getName());
        }
    }

    protected Object value(Field field, TypeLiteral<?> fieldType, Annotation bindingAnnotation) {
        if (this.injector.getPredicates().isProviderType(fieldType.getRawType())) {
            Type parameterType = GenericTypesUtils.getGenericParameterType(field.getGenericType());
            if (parameterType == null) {
                this.injector.throwException("Provider field %s.%s must be parameterized to be usable for injection", field.getDeclaringClass().getName(), field.getName());
            }
            return this.injector.getProvider(Key.get(TypeLiteral.of(parameterType), bindingAnnotation));
        }
        Key<?> key = Key.get(fieldType, bindingAnnotation);
        return this.injector.getInstanceWithCycleProtection(key);
    }

    private TypeLiteral<?> getFieldType(Object object, Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof TypeVariable) {
            Class<?> objectClass = object.getClass();
            TypeLiteral<?> typeLiteral = GenericTypesUtils.resolveVariableType(objectClass, field, genericType);
            if (typeLiteral == null) {
                return (TypeLiteral)this.injector.throwException("Unable to resolve type parameter %s for the field %s type %s ", genericType.getTypeName(), field.getName(), objectClass.getName());
            }
            return typeLiteral;
        }
        return TypeLiteral.of(genericType);
    }

    @Override
    public String getName() {
        return "field injecting provider";
    }
}

