/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.TypeLiteral;
import io.bootique.di.spi.DecoratorProvider;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.FieldInjectingProvider;
import io.bootique.di.spi.GenericTypesUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.inject.Provider;

class FieldInjectingDecoratorProvider<T>
implements DecoratorProvider<T> {
    private final Class<? extends T> implementation;
    private final DefaultInjector injector;
    private final DecoratorProvider<T> delegate;

    FieldInjectingDecoratorProvider(Class<? extends T> implementation, DecoratorProvider<T> delegate, DefaultInjector injector) {
        this.delegate = delegate;
        this.injector = injector;
        this.implementation = implementation;
    }

    @Override
    public Provider<T> get(final Provider<T> undecorated) {
        return new FieldInjectingProvider<T>(this.delegate.get(undecorated), this.injector){

            @Override
            protected Object value(Field field, TypeLiteral<?> fieldType, Annotation bindingAnnotation) {
                if (this.injector.getPredicates().isProviderType(fieldType.getRawType())) {
                    Class objectClass = GenericTypesUtils.parameterClass(field.getGenericType());
                    if (objectClass == null) {
                        return this.injector.throwException("Provider field %s.%s of type %s must be parameterized to be usable for injection", field.getDeclaringClass().getName(), field.getName(), fieldType.getRawType().getName());
                    }
                    if (objectClass.isAssignableFrom(FieldInjectingDecoratorProvider.this.implementation)) {
                        return undecorated;
                    }
                } else if (fieldType.getRawType().isAssignableFrom(FieldInjectingDecoratorProvider.this.implementation)) {
                    return undecorated.get();
                }
                return super.value(field, fieldType, bindingAnnotation);
            }
        };
    }
}

