/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.DIRuntimeException;
import io.bootique.di.spi.AfterScopeEnd;
import io.bootique.di.spi.DIUtil;
import io.bootique.di.spi.DefaultScope;
import javax.inject.Provider;

public class DefaultScopeProvider<T>
implements Provider<T> {
    private final Provider<T> delegate;
    private final DefaultScope scope;
    private volatile T instance;

    public DefaultScopeProvider(DefaultScope scope, Provider<T> delegate) {
        this.scope = scope;
        this.delegate = delegate;
        scope.addScopeEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Object localInstance = this.instance;
        if (localInstance == null) {
            DefaultScopeProvider defaultScopeProvider = this;
            synchronized (defaultScopeProvider) {
                localInstance = this.instance;
                if (localInstance == null) {
                    this.instance = this.delegate.get();
                    localInstance = this.instance;
                    if (localInstance == null) {
                        throw new DIRuntimeException("Underlying provider (%s) returned NULL instance", DIUtil.getProviderName(this.delegate));
                    }
                    this.scope.addScopeEventListener(localInstance);
                }
            }
        }
        return localInstance;
    }

    @AfterScopeEnd
    public void afterScopeEnd() throws Exception {
        T localInstance = this.instance;
        if (localInstance != null) {
            this.instance = null;
            this.scope.removeScopeEventListener(localInstance);
        }
    }
}

