/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.Key;
import io.bootique.di.Scope;
import io.bootique.di.ScopeBuilder;
import io.bootique.di.spi.ConstructorInjectingProvider;
import io.bootique.di.spi.CustomProvidersProvider;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.FieldInjectingProvider;
import io.bootique.di.spi.InstanceProvider;
import io.bootique.di.spi.MemberInjectingProvider;
import io.bootique.di.spi.MethodInjectingProvider;
import javax.inject.Provider;

public abstract class DICollectionBuilder<K, E>
implements ScopeBuilder {
    protected final DefaultInjector injector;
    protected final Key<K> bindingKey;

    public DICollectionBuilder(Key<K> bindingKey, DefaultInjector injector) {
        this.injector = injector;
        this.bindingKey = bindingKey;
    }

    protected Provider<E> createInstanceProvider(E value) {
        InstanceProvider<E> provider0 = new InstanceProvider<E>(value);
        FieldInjectingProvider<E> provider1 = new FieldInjectingProvider<E>(provider0, this.injector);
        if (!this.injector.isMethodInjectionEnabled()) {
            return provider1;
        }
        return new MethodInjectingProvider<E>(provider1, this.injector);
    }

    protected Provider<E> createProviderProvider(Class<? extends Provider<? extends E>> providerType) {
        Key<? extends Provider<? extends E>> providerKey = Key.get(providerType);
        Provider providerProvider = () -> {
            this.injector.trace(() -> "Resolving custom provider of type " + providerType);
            if (!this.injector.hasProvider(providerKey)) {
                ConstructorInjectingProvider provider0 = new ConstructorInjectingProvider(providerType, this.injector);
                MemberInjectingProvider provider1 = new FieldInjectingProvider(provider0, this.injector);
                if (this.injector.isMethodInjectionEnabled()) {
                    provider1 = new MethodInjectingProvider(provider1, this.injector);
                }
                this.injector.putBinding(providerKey, provider1);
            }
            return (Provider)this.injector.getInstance(providerKey);
        };
        CustomProvidersProvider provider3 = new CustomProvidersProvider(this.injector, providerType, providerProvider);
        MemberInjectingProvider provider4 = new FieldInjectingProvider(provider3, this.injector);
        if (this.injector.isMethodInjectionEnabled()) {
            provider4 = new MethodInjectingProvider(provider4, this.injector);
        }
        return provider4;
    }

    protected <SubT extends E> Provider<SubT> getByTypeProvider(Class<SubT> interfaceType) {
        return this.getByKeyProvider(Key.get(interfaceType));
    }

    protected <SubT extends E> Provider<SubT> getByKeyProvider(Key<SubT> key) {
        if (!this.injector.hasProvider(key)) {
            this.injector.putBinding(key, (Provider)null);
        }
        return () -> this.injector.getInstance(key);
    }

    @Override
    public void in(Scope scope) {
        this.injector.changeBindingScope(this.bindingKey, scope);
    }

    @Override
    public void inSingletonScope() {
        this.in(this.injector.getSingletonScope());
    }

    @Override
    public void withoutScope() {
        this.in(this.injector.getNoScope());
    }

    @Override
    public void initOnStartup() {
        this.injector.markForEarlySetup(this.bindingKey);
    }
}

