/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.Key;
import io.bootique.di.TypeLiteral;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.GenericTypesUtils;
import io.bootique.di.spi.NamedProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;

class ConstructorInjectingProvider<T>
implements NamedProvider<T> {
    private final Constructor<? extends T> constructor;
    private final DefaultInjector injector;
    private final Annotation[] bindingAnnotations;

    ConstructorInjectingProvider(Class<? extends T> implementation, DefaultInjector injector) {
        this.injector = injector;
        this.constructor = this.findConstructor(implementation);
        this.bindingAnnotations = this.collectParametersQualifiers(this.constructor);
    }

    private Constructor<? extends T> findConstructor(Class<? extends T> implementation) {
        Constructor<?>[] constructors = implementation.getDeclaredConstructors();
        Constructor<?> lastMatch = null;
        int lastSize = -1;
        for (Constructor<?> constructor : constructors) {
            int size = constructor.getParameterCount();
            if (size <= lastSize) continue;
            if (size == 0) {
                lastSize = 0;
                lastMatch = constructor;
                continue;
            }
            if (!this.injector.getPredicates().hasInjectAnnotation(constructor)) continue;
            lastSize = size;
            lastMatch = constructor;
        }
        if (lastMatch == null) {
            return (Constructor)this.injector.throwException("No applicable constructor is found for constructor injection in class '%s'", implementation.getName());
        }
        lastMatch.setAccessible(true);
        return lastMatch;
    }

    private Annotation[] collectParametersQualifiers(Constructor<? extends T> constructor) {
        Annotation[] result = new Annotation[constructor.getParameterCount()];
        Annotation[][] annotations = constructor.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = annotations[i]) {
                if (!this.injector.getPredicates().isQualifierAnnotation(annotation)) continue;
                result[i] = annotation;
            }
        }
        return result;
    }

    public T get() {
        Class<?>[] constructorParameters = this.constructor.getParameterTypes();
        Type[] genericTypes = this.constructor.getGenericParameterTypes();
        Object[] args = new Object[constructorParameters.length];
        for (int i = 0; i < constructorParameters.length; ++i) {
            int idx = i;
            this.injector.trace(() -> "Get argument " + idx + " for " + this.getName());
            args[i] = this.value(constructorParameters[i], genericTypes[i], this.bindingAnnotations[i]);
        }
        try {
            this.injector.trace(() -> "Invoking " + this.getName());
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            return this.injector.throwException("Error invoking %s", e, this.getName());
        }
    }

    protected Object value(Class<?> parameter, Type genericType, Annotation bindingAnnotation) {
        if (this.injector.getPredicates().isProviderType(parameter)) {
            Type parameterType = GenericTypesUtils.getGenericParameterType(genericType);
            if (parameterType == null) {
                return this.injector.throwException("Constructor provider parameter %s must be parameterized to be usable for injection", parameter.getName());
            }
            return this.injector.getProvider(Key.get(TypeLiteral.of(parameterType), bindingAnnotation));
        }
        Key key = Key.get(TypeLiteral.of(genericType), bindingAnnotation);
        return this.injector.getInstanceWithCycleProtection(key);
    }

    @Override
    public String getName() {
        return "constructor of class '" + this.constructor.getDeclaringClass().getName() + "'";
    }
}

