/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.spi.ConstructorInjectingProvider;
import io.bootique.di.spi.DecoratorProvider;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.GenericTypesUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Provider;

class ConstructorInjectingDecoratorProvider<T>
implements DecoratorProvider<T> {
    private final Class<? extends T> implementation;
    private final DefaultInjector injector;

    ConstructorInjectingDecoratorProvider(Class<? extends T> implementation, DefaultInjector injector) {
        this.implementation = implementation;
        this.injector = injector;
    }

    @Override
    public Provider<T> get(final Provider<T> undecorated) {
        return new ConstructorInjectingProvider<T>(this.implementation, this.injector){

            @Override
            protected Object value(Class<?> parameter, Type genericType, Annotation bindingAnnotation) {
                if (ConstructorInjectingDecoratorProvider.this.injector.getPredicates().isProviderType(parameter)) {
                    Class objectClass = GenericTypesUtils.parameterClass(genericType);
                    if (objectClass == null) {
                        return ConstructorInjectingDecoratorProvider.this.injector.throwException("Constructor provider parameter %s must be parameterized to be usable for injection", parameter.getName());
                    }
                    if (objectClass.isAssignableFrom(ConstructorInjectingDecoratorProvider.this.implementation)) {
                        return undecorated;
                    }
                } else if (parameter.isAssignableFrom(ConstructorInjectingDecoratorProvider.this.implementation)) {
                    return undecorated.get();
                }
                return super.value(parameter, genericType, bindingAnnotation);
            }
        };
    }
}

