/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.Key;
import io.bootique.di.Scope;
import io.bootique.di.spi.Decoration;
import io.bootique.di.spi.DecoratorProvider;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.NoScope;
import java.util.List;
import javax.inject.Provider;

class Binding<T> {
    private final Key<T> key;
    private final Provider<T> original;
    private Provider<T> decorated;
    private Provider<T> scoped;
    private Scope scope;
    private boolean optional;

    Binding(Key<T> key, Provider<T> provider, Scope initialScope, boolean optional) {
        this.key = key;
        this.original = provider;
        this.decorated = provider;
        this.optional = optional;
        this.changeScope(initialScope);
    }

    void changeScope(Scope scope) {
        if (scope == null) {
            scope = NoScope.INSTANCE;
        } else if (this.optional) {
            scope = NoScope.INSTANCE;
        }
        this.scoped = scope.scope(this.original);
        this.scope = scope;
    }

    void decorate(DefaultInjector injector, Decoration<T> decoration) {
        List<DecoratorProvider<T>> decorators = decoration.decorators();
        if (decorators.isEmpty()) {
            return;
        }
        Provider<T> provider = this.original;
        for (DecoratorProvider<T> decoratorProvider : decorators) {
            provider = decoratorProvider.get(provider);
        }
        this.decorated = injector.wrapProvider(this.key, provider);
        this.scoped = this.scope.scope(this.decorated);
    }

    Provider<T> getOriginal() {
        return this.original;
    }

    Provider<T> getScoped() {
        return this.scoped;
    }

    Scope getScope() {
        return this.scope;
    }

    void setOptional(boolean optional) {
        this.optional = optional;
    }

    boolean isOptional() {
        return this.optional;
    }

    Key<T> getKey() {
        return this.key;
    }
}

