/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di;

import io.bootique.di.DIRuntimeException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TypeLiteral<T> {
    private static final Class<?> WILDCARD_MARKER = WildcardMarker.class;
    private final Class<? super T> type;
    private final String typeName;
    private final String[] argumentTypes;

    public static <T> TypeLiteral<T> of(Class<T> type) {
        return new TypeLiteral<T>(type);
    }

    public static <T> TypeLiteral<T> of(Type type) {
        return new TypeLiteral<T>(type);
    }

    public static <T> TypeLiteral<T> of(Class<T> rawType, Type ... parameters) {
        return new TypeLiteral<T>(rawType, parameters);
    }

    public static <T> TypeLiteral<List<T>> listOf(Class<? extends T> type) {
        return new TypeLiteral<List<T>>(List.class, type);
    }

    public static <T> TypeLiteral<List<T>> listOf(TypeLiteral<? extends T> type) {
        return new TypeLiteral<List<T>>(List.class, type.toString());
    }

    public static <T> TypeLiteral<Set<T>> setOf(Class<? extends T> valueType) {
        return new TypeLiteral<Set<T>>(Set.class, valueType);
    }

    public static <T> TypeLiteral<Set<T>> setOf(TypeLiteral<? extends T> valueType) {
        return new TypeLiteral<Set<T>>(Set.class, valueType.toString());
    }

    public static <K, V> TypeLiteral<Map<K, V>> mapOf(Class<? extends K> keyType, Class<? extends V> valueType) {
        return new TypeLiteral<Map<K, V>>(Map.class, keyType, valueType);
    }

    public static <K, V> TypeLiteral<Map<K, V>> mapOf(TypeLiteral<? extends K> keyType, TypeLiteral<? extends V> valueType) {
        return new TypeLiteral<Map<K, V>>(Map.class, keyType.toString(), valueType.toString());
    }

    public static <T> TypeLiteral<Optional<T>> optionalOf(Class<? extends T> type) {
        return new TypeLiteral<Optional<T>>(Optional.class, type);
    }

    public static <T> TypeLiteral<Optional<T>> optionalOf(TypeLiteral<? extends T> type) {
        return new TypeLiteral<Optional<T>>(Optional.class, type.toString());
    }

    static <T> TypeLiteral<T> normalize(TypeLiteral<T> type) {
        Objects.requireNonNull(type, "Null type");
        if (type.getClass() == TypeLiteral.class) {
            return type;
        }
        return new TypeLiteral<T>(type.getRawType(), type.argumentTypes);
    }

    protected TypeLiteral() {
        Type genericType = TypeLiteral.getGenericSuperclassType(this.getClass());
        this.type = TypeLiteral.getRawType(genericType);
        this.typeName = this.type.getName();
        Type[] argumentTypes = TypeLiteral.getArgumentTypes(genericType);
        this.argumentTypes = new String[argumentTypes.length];
        this.initArgumentTypes(argumentTypes);
    }

    private TypeLiteral(Type type) {
        this.type = TypeLiteral.getRawType(Objects.requireNonNull(type, "No type"));
        this.typeName = this.type.getName();
        Type[] argumentTypes = TypeLiteral.getArgumentTypes(type);
        this.argumentTypes = new String[argumentTypes.length];
        this.initArgumentTypes(argumentTypes);
    }

    private TypeLiteral(Class<? super T> type, String ... argumentTypes) {
        this.type = type;
        this.typeName = type.getName();
        this.argumentTypes = argumentTypes;
    }

    private TypeLiteral(Class<? super T> type, Type ... argumentsType) {
        this.type = Objects.requireNonNull(type, "No class");
        this.typeName = type.getName();
        this.argumentTypes = new String[argumentsType.length];
        this.initArgumentTypes(argumentsType);
    }

    private void initArgumentTypes(Type ... argumentsType) {
        for (int i = 0; i < argumentsType.length; ++i) {
            this.argumentTypes[i] = new TypeLiteral<T>(argumentsType[i]).toString();
        }
    }

    private static Type getGenericSuperclassType(Class<?> subclass) {
        Type superclass = subclass.getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new DIRuntimeException("Missing type parameter, use like this: new TypeLiteral<MyType>(){};", new Object[0]);
        }
        ParameterizedType parameterized = (ParameterizedType)superclass;
        return parameterized.getActualTypeArguments()[0];
    }

    public Class<? super T> getRawType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeLiteral)) {
            return false;
        }
        TypeLiteral that = (TypeLiteral)o;
        if (!this.typeName.equals(that.typeName)) {
            return false;
        }
        return Arrays.equals(this.argumentTypes, that.argumentTypes);
    }

    public int hashCode() {
        int result = this.typeName.hashCode();
        result = 31 * result + Arrays.hashCode(this.argumentTypes);
        return result;
    }

    public String toString() {
        Object result = this.typeName;
        if (this.argumentTypes.length > 0) {
            result = (String)result + Arrays.toString(this.argumentTypes);
        }
        return result;
    }

    private static Type[] getArgumentTypes(Type type) {
        if (type instanceof Class) {
            return new Type[0];
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            if (!(componentType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Expected ParameterizedType, got " + componentType.toString());
            }
            return ((ParameterizedType)componentType).getActualTypeArguments();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] lowerBounds = wildcardType.getLowerBounds();
            Type[] upperBounds = wildcardType.getUpperBounds();
            Class<Object> lower = lowerBounds.length > 0 ? wildcardType.getLowerBounds()[0] : Object.class;
            Class<Object> upper = upperBounds.length > 0 ? wildcardType.getUpperBounds()[0] : Object.class;
            return new Type[]{lower, upper};
        }
        if (type instanceof TypeVariable) {
            throw new DIRuntimeException("Variable type %s can't be fully resolved", type);
        }
        return new Type[]{type};
    }

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            if (!(componentType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Expected ParameterizedType, got " + componentType.toString());
            }
            Class rawType = (Class)((ParameterizedType)componentType).getRawType();
            return Array.newInstance(rawType, 0).getClass();
        }
        if (type instanceof WildcardType) {
            return WILDCARD_MARKER;
        }
        return Object.class;
    }

    private static interface WildcardMarker {
    }
}

