/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di;

import io.bootique.di.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Named;

public class Key<T> {
    private static final KeyQualifier NO_QUALIFIER = new NoQualifier();
    private final TypeLiteral<T> type;
    private final KeyQualifier qualifier;

    public static <T> Key<T> get(Class<T> type) {
        return Key.get(TypeLiteral.of(type));
    }

    public static <T> Key<T> get(Class<T> type, String bindingName) {
        return Key.get(TypeLiteral.of(type), bindingName);
    }

    public static <T> Key<T> get(Class<T> type, Class<? extends Annotation> annotationType) {
        return Key.get(TypeLiteral.of(type), annotationType);
    }

    public static <T> Key<T> get(Class<T> type, Annotation annotationInstance) {
        return Key.get(TypeLiteral.of(type), annotationInstance);
    }

    public static <T> Key<T> get(TypeLiteral<T> typeLiteral) {
        return Key.get(typeLiteral, (String)null);
    }

    public static <T> Key<T> get(TypeLiteral<T> typeLiteral, String bindingName) {
        return new Key<T>(typeLiteral, bindingName);
    }

    public static <T> Key<T> get(TypeLiteral<T> typeLiteral, Class<? extends Annotation> annotationType) {
        return new Key<T>(typeLiteral, annotationType);
    }

    public static <T> Key<T> get(TypeLiteral<T> typeLiteral, Annotation annotationInstance) {
        return new Key<T>(typeLiteral, annotationInstance);
    }

    public static <T> Key<List<T>> getListOf(Class<T> type, Class<? extends Annotation> qualifier) {
        return Key.get(TypeLiteral.listOf(type), qualifier);
    }

    public static <T> Key<List<T>> getListOf(Class<T> type, String bindingName) {
        return Key.get(TypeLiteral.listOf(type), bindingName);
    }

    public static <T> Key<List<T>> getListOf(Class<T> type) {
        return Key.get(TypeLiteral.listOf(type));
    }

    public static <T> Key<Set<T>> getSetOf(Class<T> valueType, Class<? extends Annotation> qualifier) {
        return Key.get(TypeLiteral.setOf(valueType), qualifier);
    }

    public static <T> Key<Set<T>> getSetOf(Class<T> valueType, String bindingName) {
        return Key.get(TypeLiteral.setOf(valueType), bindingName);
    }

    public static <T> Key<Set<T>> getSetOf(Class<T> valueType) {
        return Key.get(TypeLiteral.setOf(valueType));
    }

    public static <K, V> Key<Map<K, V>> getMapOf(Class<K> keyType, Class<V> valueType, Class<? extends Annotation> qualifier) {
        return Key.get(TypeLiteral.mapOf(keyType, valueType), qualifier);
    }

    public static <K, V> Key<Map<K, V>> getMapOf(Class<K> keyType, Class<V> valueType, String bindingName) {
        return Key.get(TypeLiteral.mapOf(keyType, valueType), bindingName);
    }

    public static <K, V> Key<Map<K, V>> getMapOf(Class<K> keyType, Class<V> valueType) {
        return Key.get(TypeLiteral.mapOf(keyType, valueType));
    }

    public static <K, V> Key<Map<K, V>> getMapOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType, Class<? extends Annotation> qualifier) {
        return Key.get(TypeLiteral.mapOf(keyType, valueType), qualifier);
    }

    public static <K, V> Key<Map<K, V>> getMapOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType, String bindingName) {
        return Key.get(TypeLiteral.mapOf(keyType, valueType), bindingName);
    }

    public static <K, V> Key<Map<K, V>> getMapOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return Key.get(TypeLiteral.mapOf(keyType, valueType));
    }

    public static <T> Key<Optional<T>> getOptionalOf(Class<? extends T> type) {
        return Key.get(TypeLiteral.optionalOf(type));
    }

    public static <T> Key<Optional<T>> getOptionalOf(Key<T> key) {
        TypeLiteral<Optional<T>> type = TypeLiteral.optionalOf(key.getType());
        if (key.getBindingName() != null) {
            return Key.get(type, key.getBindingName());
        }
        if (key.getBindingAnnotation() != null) {
            return Key.get(type, key.getBindingAnnotation());
        }
        return Key.get(type);
    }

    protected Key(TypeLiteral<T> type, String bindingName) {
        this.type = TypeLiteral.normalize(type);
        this.qualifier = bindingName != null && bindingName.length() > 0 ? new NamedKeyQualifier(bindingName) : NO_QUALIFIER;
    }

    protected Key(TypeLiteral<T> type, Class<? extends Annotation> annotationType) {
        this.type = TypeLiteral.normalize(type);
        this.qualifier = annotationType == null ? NO_QUALIFIER : new AnnotationTypeQualifier(annotationType);
    }

    protected Key(TypeLiteral<T> type, Annotation annotationInstance) {
        String name;
        this.type = TypeLiteral.normalize(type);
        this.qualifier = annotationInstance == null ? NO_QUALIFIER : (annotationInstance instanceof Named ? ((name = ((Named)annotationInstance).value()).length() > 0 ? new NamedKeyQualifier(name) : NO_QUALIFIER) : new AnnotationTypeQualifier(annotationInstance.annotationType()));
    }

    public TypeLiteral<T> getType() {
        return this.type;
    }

    public String getBindingName() {
        if (this.qualifier instanceof NamedKeyQualifier) {
            return ((NamedKeyQualifier)this.qualifier).getName();
        }
        return null;
    }

    public Class<? extends Annotation> getBindingAnnotation() {
        if (this.qualifier instanceof AnnotationTypeQualifier) {
            return ((AnnotationTypeQualifier)this.qualifier).getAnnotationType();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Key) {
            Key key = (Key)object;
            if (!this.type.equals(key.type)) {
                return false;
            }
            return this.qualifier.equals(key.qualifier);
        }
        return false;
    }

    public int hashCode() {
        return 407 + 11 * this.type.hashCode() + this.qualifier.hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<BindingKey: ");
        buffer.append(this.type);
        if (this.qualifier != NO_QUALIFIER) {
            buffer.append(", ").append(this.qualifier);
        }
        buffer.append('>');
        return buffer.toString();
    }

    static class NamedKeyQualifier
    implements KeyQualifier {
        private final String name;

        NamedKeyQualifier(String name) {
            this.name = Objects.requireNonNull(name);
        }

        private String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NamedKeyQualifier)) {
                return false;
            }
            return ((NamedKeyQualifier)other).getName().equals(this.name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public String toString() {
            return "'" + this.name + "'";
        }
    }

    static class AnnotationTypeQualifier
    implements KeyQualifier {
        private final Class<? extends Annotation> annotationType;

        AnnotationTypeQualifier(Class<? extends Annotation> annotationType) {
            this.annotationType = Objects.requireNonNull(annotationType);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationTypeQualifier)) {
                return false;
            }
            return ((AnnotationTypeQualifier)other).annotationType.equals(this.annotationType);
        }

        @Override
        public int hashCode() {
            return this.annotationType.hashCode();
        }

        @Override
        public String toString() {
            return "@" + this.annotationType.getName();
        }

        public Class<? extends Annotation> getAnnotationType() {
            return this.annotationType;
        }
    }

    static final class NoQualifier
    implements KeyQualifier {
        private NoQualifier() {
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return "no qualifier";
        }
    }

    static interface KeyQualifier {
        public boolean equals(Object var1);

        public int hashCode();

        public String toString();
    }
}

