/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di;

import io.bootique.di.Key;
import java.util.Objects;
import java.util.function.Supplier;

public class InjectionTraceElement {
    private static final Supplier<String> EMPTY_MESSAGE_SUPPLIER = () -> "";
    private final Key<?> bindingKey;
    private Supplier<String> message = EMPTY_MESSAGE_SUPPLIER;

    public InjectionTraceElement(Key<?> bindingKey) {
        this.bindingKey = bindingKey;
    }

    public void setMessage(Supplier<String> messageSupplier) {
        this.message = Objects.requireNonNull(messageSupplier);
    }

    public String getMessage() {
        return this.message.get();
    }

    public Key<?> getBindingKey() {
        return this.bindingKey;
    }

    public String toString() {
        if (this.message == null) {
            return this.bindingKey.toString();
        }
        return this.bindingKey + " -> " + this.message.get();
    }
}

