/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di;

import io.bootique.di.InjectionTraceElement;

public class DIRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 396131653561690312L;
    private InjectionTraceElement[] injectionTrace = new InjectionTraceElement[0];

    public DIRuntimeException() {
    }

    public DIRuntimeException(String messageFormat, Object ... messageArgs) {
        super(String.format(messageFormat, messageArgs));
    }

    public DIRuntimeException(Throwable cause) {
        super(cause);
    }

    public DIRuntimeException(String messageFormat, Throwable cause, Object ... messageArgs) {
        super(String.format(messageFormat, messageArgs), cause, true, cause == null);
    }

    public void setInjectionTrace(InjectionTraceElement[] injectionTrace) {
        this.injectionTrace = injectionTrace;
    }

    public InjectionTraceElement[] getInjectionTrace() {
        return this.injectionTrace;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(this.getOriginalMessage());
        if (this.injectionTrace.length > 0) {
            sb.append("\n\n Injection trace: \n");
            for (int i = 0; i < this.injectionTrace.length; ++i) {
                sb.append("\n [").append(i).append(']').append(" resolving key ").append(this.injectionTrace[i].getBindingKey());
                sb.append("\n    -> ").append(this.injectionTrace[i].getMessage()).append('\n');
            }
        }
        return sb.toString();
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }
}

