/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di;

import io.bootique.di.BQModule;
import io.bootique.di.DIRuntimeException;
import io.bootique.di.Injector;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.InjectorPredicates;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Provider;

public class DIBootstrap {
    public static InjectorBuilder injectorBuilder() {
        return new InjectorBuilder(new BQModule[0]);
    }

    public static InjectorBuilder injectorBuilder(BQModule ... modules) {
        return new InjectorBuilder(modules);
    }

    public static InjectorBuilder injectorBuilder(Collection<BQModule> modules) {
        return DIBootstrap.injectorBuilder(modules.toArray(new BQModule[0]));
    }

    public static Injector createInjector(BQModule ... modules) throws DIRuntimeException {
        return DIBootstrap.injectorBuilder(modules).build();
    }

    public static Injector createInjector(Collection<BQModule> modules) {
        return DIBootstrap.injectorBuilder(modules).build();
    }

    public static class InjectorBuilder {
        private Set<DefaultInjector.Options> options = EnumSet.noneOf(DefaultInjector.Options.class);
        private InjectorPredicates injectorPredicates;
        private BQModule[] modules;

        private InjectorBuilder(BQModule ... modules) {
            this.modules = modules;
            this.injectorPredicates = new InjectorPredicates();
        }

        public InjectorBuilder disableDynamicBindings() {
            this.options.add(DefaultInjector.Options.DISABLE_DYNAMIC_BINDINGS);
            return this;
        }

        public InjectorBuilder declaredOverridesOnly() {
            this.options.add(DefaultInjector.Options.DECLARED_OVERRIDE_ONLY);
            return this;
        }

        public InjectorBuilder defaultSingletonScope() {
            this.options.add(DefaultInjector.Options.SINGLETON_SCOPE_BY_DEFAULT);
            return this;
        }

        public InjectorBuilder enableMethodInjection() {
            this.options.add(DefaultInjector.Options.ENABLE_METHOD_INJECTION);
            return this;
        }

        public InjectorBuilder disableTrace() {
            this.options.add(DefaultInjector.Options.DISABLE_TRACE);
            return this;
        }

        public InjectorBuilder disableProxyCreation() {
            this.options.add(DefaultInjector.Options.DISABLE_PROXY);
            return this;
        }

        public InjectorBuilder withProvidesMethodPredicate(Predicate<Method> providesMethodPredicate) {
            this.injectorPredicates.setProvidesMethodPredicate(providesMethodPredicate);
            return this;
        }

        public InjectorBuilder withInjectAnnotationPredicate(Predicate<AccessibleObject> injectPredicate) {
            this.injectorPredicates.setInjectPredicate(injectPredicate);
            return this;
        }

        public InjectorBuilder withProviderPredicate(Predicate<Type> providerPredicate) {
            this.injectorPredicates.setProviderPredicate(providerPredicate);
            return this;
        }

        public InjectorBuilder withQualifierPredicate(Predicate<Class<? extends Annotation>> qualifierPredicate) {
            this.injectorPredicates.setQualifierPredicate(qualifierPredicate);
            return this;
        }

        public InjectorBuilder withSingletonPredicate(Predicate<AnnotatedElement> singletonPredicate) {
            this.injectorPredicates.setSingletonPredicate(singletonPredicate);
            return this;
        }

        public <T> InjectorBuilder withProviderWrapper(Function<Provider<T>, Provider<T>> providerFunction) {
            this.injectorPredicates.setProviderFunction(providerFunction);
            return this;
        }

        public InjectorBuilder withExceptionProvider(InjectorPredicates.ExceptionProvider<?> provider) {
            this.injectorPredicates.setExceptionProvider(provider);
            return this;
        }

        public Injector build() {
            return new DefaultInjector(this.options, this.injectorPredicates, this.modules);
        }
    }
}

