/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.AbstractTempFileS3OutputStream;
import io.awspring.cloud.s3.Location;
import io.awspring.cloud.s3.ObjectMetadata;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import java.io.File;
import java.io.IOException;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

class DiskBufferingS3OutputStream
extends AbstractTempFileS3OutputStream {
    private final S3Client s3Client;

    DiskBufferingS3OutputStream(Location location, S3Client s3Client, @Nullable ObjectMetadata objectMetadata) throws IOException {
        this(location, s3Client, objectMetadata, null);
    }

    DiskBufferingS3OutputStream(Location location, S3Client client, @Nullable ObjectMetadata objectMetadata, @Nullable S3ObjectContentTypeResolver contentTypeResolver) throws IOException {
        super(location, objectMetadata, contentTypeResolver);
        this.s3Client = client;
    }

    @Override
    protected void upload(PutObjectRequest putObjectRequest) {
        this.s3Client.putObject(putObjectRequest, RequestBody.fromFile((File)this.file));
    }
}

