/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.quarkus.operator.ops;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;

@ApplicationScoped
public class SecretOperations {
    @Inject
    KubernetesClient kube;

    public void createSecret(CustomResource<?, ?> resource, String name, Map<String, String> values) {
        SecretBuilder builder = (SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(name)).endMetadata();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            builder.addToData(entry.getKey(), Base64.getEncoder().encodeToString(entry.getValue().getBytes(StandardCharsets.UTF_8)));
        }
        ((NonNamespaceOperation)this.kube.secrets().inNamespace(resource.getMetadata().getNamespace())).create((Object)builder.build());
    }

    public void createSecret(CustomResource<?, ?> resource, String name, String key, String value) {
        SecretBuilder builder = (SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(name)).endMetadata();
        builder.addToData(key, Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8)));
        ((NonNamespaceOperation)this.kube.secrets().inNamespace(resource.getMetadata().getNamespace())).create((Object)builder.build());
    }

    public void deleteSecret(CustomResource<?, ?> resource, String name) {
        Secret secret = ((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(name)).endMetadata()).build();
        ((NonNamespaceOperation)this.kube.secrets().inNamespace(resource.getMetadata().getNamespace())).delete((Object)secret);
    }
}

