/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.quarkus.operator.ops;

import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;

@ApplicationScoped
public class CustomResourceOperations {
    @Inject
    KubernetesClient kube;

    public void updateCustomResource(CustomResource<?, ?> resource) {
        ReplaceDeletable r = this.kube.resource(resource).inNamespace(resource.getMetadata().getNamespace()).lockResourceVersion(resource.getMetadata().getResourceVersion());
        r.replace();
    }

    public void updateCustomResourceStatus(CustomResource<?, ?> resource) {
        Resource r = (Resource)((NonNamespaceOperation)this.kube.resources(resource.getClass()).inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName());
        CustomResource fromServer = (CustomResource)r.fromServer().get();
        fromServer.setStatus(resource.getStatus());
        r.patchStatus();
    }

    public void deleteCustomResource(CustomResource<?, ?> resource) {
        Resource r = (Resource)((NonNamespaceOperation)this.kube.resources(resource.getClass()).inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName());
        r.delete();
    }
}

