/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.quarkus.operator.ops;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;

@ApplicationScoped
public class ConfigMapOperations {
    @Inject
    KubernetesClient kube;

    public void createConfigMap(CustomResource<?, ?> resource, String name, Map<String, String> values) {
        ConfigMapBuilder builder = (ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(name)).endMetadata();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            builder.addToData(entry.getKey(), entry.getValue());
        }
        ((NonNamespaceOperation)this.kube.configMaps().inNamespace(resource.getMetadata().getNamespace())).create((Object)builder.build());
    }

    public void createConfigMap(CustomResource<?, ?> resource, String name, String key, String value) {
        ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(name)).endMetadata()).addToData(name, value)).build();
        ((NonNamespaceOperation)this.kube.configMaps().inNamespace(resource.getMetadata().getNamespace())).create((Object)configMap);
    }

    public void deleteConfigMap(CustomResource<?, ?> resource, String name) {
        ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(name)).endMetadata()).build();
        ((NonNamespaceOperation)this.kube.configMaps().inNamespace(resource.getMetadata().getNamespace())).delete((Object)configMap);
    }
}

