/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.quarkus.deployment;

import io.automatiko.engine.api.Model;
import io.automatiko.engine.api.codegen.AutomatikoConfigProperties;
import io.automatiko.engine.api.config.AutomatikoBuildConfig;
import io.automatiko.engine.codegen.ApplicationGenerator;
import io.automatiko.engine.codegen.GeneratedFile;
import io.automatiko.engine.codegen.Generator;
import io.automatiko.engine.codegen.GeneratorContext;
import io.automatiko.engine.codegen.LambdaParser;
import io.automatiko.engine.codegen.context.ApplicationBuildContext;
import io.automatiko.engine.codegen.context.QuarkusApplicationBuildContext;
import io.automatiko.engine.codegen.decision.DecisionCodegen;
import io.automatiko.engine.codegen.di.CDIDependencyInjectionAnnotator;
import io.automatiko.engine.codegen.di.DependencyInjectionAnnotator;
import io.automatiko.engine.codegen.process.ProcessCodegen;
import io.automatiko.engine.codegen.process.persistence.PersistenceGenerator;
import io.automatiko.engine.quarkus.AutomatikoBuildTimeConfig;
import io.automatiko.engine.quarkus.deployment.AutomatikoBuildData;
import io.automatiko.engine.quarkus.deployment.QuarkusGeneratorContext;
import io.automatiko.engine.services.utils.IoUtils;
import io.automatiko.engine.workflow.BaseWorkItem;
import io.automatiko.engine.workflow.builder.BuilderContext;
import io.automatiko.engine.workflow.builder.WorkflowBuilder;
import io.automatiko.engine.workflow.marshalling.impl.AutomatikoMessages;
import io.automatiko.engine.workflow.process.executable.core.ExecutableProcess;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.bootstrap.classloading.MemoryClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestListenerBuildItem;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomatikoQuarkusProcessor {
    public static final String DEFAULT_PACKAGE_NAME = "io.automatiko.app";
    private static final String FEATURE = "automatiko";
    private static final String generatedResourcesDir = System.getProperty("io.automatiko.codegen.resources.directory", "target/generated-resources/automatiko");
    private static final String generatedSourcesDir = "target/generated-sources/automatiko/";
    private static final String generatedCustomizableSourcesDir = System.getProperty("io.automatiko.codegen.sources.directory", "target/generated-sources/automatiko/");
    private static final Logger logger = LoggerFactory.getLogger(AutomatikoQuarkusProcessor.class);
    private final transient String generatedClassesDir = System.getProperty("quarkus.debug.generated-classes-dir");
    private final transient String persistenceFactoryClass = "io.automatiko.engine.addons.persistence.AbstractProcessInstancesFactory";
    private final transient String workflowsAnnotationClass = "io.automatiko.engine.api.Workflows";
    private final transient String workflowsBuilderClass = "io.automatiko.engine.workflow.builder.WorkflowBuilder";

    @BuildStep
    public void generateClassesFromResourcesStep(AutomatikoBuildTimeConfig config, PackageConfig pconfig, ArchiveRootBuildItem root, ApplicationArchivesBuildItem archives, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload, CurateOutcomeBuildItem curateOutcomeBuildItem, Capabilities capabilities, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexClass, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<GeneratedResourceBuildItem> resources, BuildProducer<ServiceProviderBuildItem> providerProducer, BuildProducer<TestListenerBuildItem> testListenerProducer) throws Exception {
        testListenerProducer.produce((BuildItem)new TestListenerBuildItem(new TestListener(){

            public void testsEnabled() {
                System.setProperty("test.runs.enabled", "true");
            }

            public void testRunStarted(Consumer<TestRunListener> listenerConsumer) {
                System.setProperty("test.runs.enabled", "true");
            }
        }));
        ArrayList<IndexView> archiveIndexes = new ArrayList<IndexView>();
        for (ApplicationArchive i : archives.getAllApplicationArchives()) {
            archiveIndexes.add(i.getIndex());
        }
        CompositeIndex archivesIndex = CompositeIndex.create(archiveIndexes);
        boolean onlyCodeAssets = false;
        if (liveReload.isLiveReload() || ConfigProvider.getConfig().getOptionalValue("quarkus.live-reload.url", String.class).isPresent() || "true".equals(System.getProperty("test.runs.enabled"))) {
            List workflowBuilderClasses = archivesIndex.getAnnotations(this.createDotName("io.automatiko.engine.api.Workflows")).stream().map(a -> a.target().asClass().name().toString()).collect(Collectors.toList());
            if (liveReload.getChangeInformation() != null && (liveReload.getChangeInformation().getAddedClasses().stream().anyMatch(clazz -> workflowBuilderClasses.contains(clazz)) || liveReload.getChangeInformation().getChangedClasses().stream().anyMatch(clazz -> workflowBuilderClasses.contains(clazz)))) {
                onlyCodeAssets = true;
            } else {
                return;
            }
        }
        AppPaths appPaths = new AppPaths(root.getResolvedPaths());
        ApplicationGenerator appGen = this.createApplicationGenerator(capabilities, config, appPaths, archivesIndex, curateOutcomeBuildItem.getApplicationModel(), onlyCodeAssets);
        Collection generatedFiles = appGen.generate();
        Collection javaFiles = generatedFiles.stream().filter(f -> f.relativePath().endsWith(".java")).collect(Collectors.toCollection(ArrayList::new));
        this.writeGeneratedFiles(appPaths, generatedFiles);
        if (!javaFiles.isEmpty()) {
            Indexer automatikoIndexer = new Indexer();
            HashSet automatikoIndex = new HashSet();
            this.compile(appPaths, curateOutcomeBuildItem.getApplicationModel(), javaFiles, launchMode.getLaunchMode(), generatedBeans, additionalIndexClass, (className, data) -> this.generateBeanBuildItem(archivesIndex, automatikoIndexer, automatikoIndex, (String)className, (byte[])data), pconfig);
            Index index = automatikoIndexer.complete();
            Collection dataEvents = index.getAllKnownSubclasses(this.createDotName("io.automatiko.engine.api.event.AbstractDataEvent"));
            dataEvents.forEach(c -> reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{c.name().toString()}).fields().methods().build()));
            this.generatePersistenceInfo(config, pconfig, appPaths, generatedBeans, additionalIndexClass, (IndexView)CompositeIndex.create((IndexView[])new IndexView[]{archivesIndex, index}), launchMode, resource, curateOutcomeBuildItem);
        }
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void reflectiveClassesRegistrationStep(ApplicationArchivesBuildItem archives, BuildProducer<ReflectiveHierarchyIgnoreWarningBuildItem> reflectiveHierarchy, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveClassHierarchy) {
        String className;
        Scanner scanner;
        InputStream in;
        URL url;
        Enumeration<URL> reflectionConfigs;
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.automatiko.engine.api.event.AbstractDataEvent"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.automatiko.engine.services.event.AbstractProcessDataEvent"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.automatiko.engine.services.event.ProcessInstanceDataEvent"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.automatiko.engine.services.event.UserTaskInstanceDataEvent"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.automatiko.engine.services.event.VariableInstanceDataEvent"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.automatiko.engine.services.event.impl.ProcessInstanceEventBody"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.automatiko.engine.services.event.impl.NodeInstanceEventBody"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.automatiko.engine.services.event.impl.ProcessErrorEventBody"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.automatiko.engine.services.event.impl.VariableInstanceEventBody"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.automatiko.engine.services.event.impl.UserTaskInstanceEventBody"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.mvel2.optimizers.dynamic.DynamicOptimizer"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.mvel2.optimizers.impl.refl.ReflectiveAccessorOptimizer"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{ArrayList.class.getCanonicalName()}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{byte[].class.getName()}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{BaseWorkItem.class.toString()}).fields().methods().build());
        ArrayList<IndexView> archiveIndexes = new ArrayList<IndexView>();
        for (ApplicationArchive i : archives.getAllApplicationArchives()) {
            archiveIndexes.add(i.getIndex());
        }
        CompositeIndex archivesIndex = CompositeIndex.create(archiveIndexes);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.automatiko.engine.services.execution.BaseFunctions"}).fields().methods().build());
        archivesIndex.getAllKnownImplementors(this.createDotName("io.automatiko.engine.api.Functions")).stream().map(c -> c.name().toString()).forEach(c -> reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{c}).methods().build()));
        DotName classDotName = this.createDotName("io.automatiko.engine.decision.dmn.DmnDecisionModel");
        if (!archivesIndex.getAnnotations(classDotName).isEmpty() || archivesIndex.getClassByName(classDotName) != null) {
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.api.builder.Message$Level")));
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNContext")));
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNDecisionResult")));
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNDecisionResult$DecisionEvaluationStatus")));
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNMessage")));
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNMessage$Severity")));
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.core.DMNMessageType")));
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyIgnoreWarningBuildItem(this.createDotName("org.kie.dmn.api.feel.runtime.events.FEELEvent")));
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.TextNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.BinaryNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.BooleanNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.NullNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.BigIntegerNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.DecimalNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.DoubleNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.FloatNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.IntNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.LongNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.ShortNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.POJONode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.ObjectNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.node.ArrayNode"}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{Long.class.getCanonicalName()}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{Integer.class.getCanonicalName()}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{Boolean.class.getCanonicalName()}).fields().methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{String.class.getCanonicalName()}).fields().methods().build());
        try {
            reflectionConfigs = Thread.currentThread().getContextClassLoader().getResources("/META-INF/automatiko.reflection.classes");
            while (reflectionConfigs.hasMoreElements()) {
                url = reflectionConfigs.nextElement();
                in = url.openStream();
                try {
                    scanner = new Scanner(in);
                    try {
                        while (scanner.hasNextLine()) {
                            className = scanner.nextLine();
                            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).constructors().methods().fields().build());
                        }
                    }
                    finally {
                        scanner.close();
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected error while reading reflection config files", (Throwable)e);
        }
        try {
            reflectionConfigs = Thread.currentThread().getContextClassLoader().getResources("/META-INF/automatiko.reflection.interfaces");
            while (reflectionConfigs.hasMoreElements()) {
                url = reflectionConfigs.nextElement();
                in = url.openStream();
                try {
                    scanner = new Scanner(in);
                    try {
                        while (scanner.hasNextLine()) {
                            className = scanner.nextLine();
                            reflectiveClassHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(Type.create((DotName)DotName.createSimple((String)className), (Type.Kind)Type.Kind.CLASS)).source(this.getClass().getSimpleName() + ">" + className).build());
                        }
                    }
                    finally {
                        scanner.close();
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected error while reading reflection config files", (Throwable)e);
        }
    }

    @BuildStep
    public void runtimeInitializationRegistrationStep(BuildProducer<RuntimeInitializedClassBuildItem> producer) {
        producer.produce((BuildItem)new RuntimeInitializedClassBuildItem(AutomatikoMessages.class.getCanonicalName()));
    }

    @BuildStep
    public void serviceProviderRegistrationStep(BuildProducer<ServiceProviderBuildItem> providerProducer) {
        providerProducer.produce((BuildItem)new ServiceProviderBuildItem(AutomatikoConfigProperties.class.getCanonicalName(), new String[]{"io.automatiko.application.app.GeneratedAutomatikoConfigProperties"}));
        providerProducer.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"net.thisptr.jackson.jq.Function"));
    }

    @BuildStep
    public void resourceFileRegistrationStep(BuildProducer<NativeImageResourceBuildItem> resource) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"templates/default-usertask-email.html"}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"templates/default-task-template.html"}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"templates/not-found-template.html"}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"automatiko-index.html"}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"/META-INF/resources/js/automatiko-authorization.js"}));
    }

    private void generatePersistenceInfo(AutomatikoBuildTimeConfig config, PackageConfig pconfig, AppPaths appPaths, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexClass, IndexView index, LaunchModeBuildItem launchMode, BuildProducer<NativeImageResourceBuildItem> resource, CurateOutcomeBuildItem curateOutcomeBuildItem) throws Exception {
        Collection<GeneratedFile> generatedFiles;
        ClassInfo persistenceClass = index.getClassByName(this.createDotName("io.automatiko.engine.addons.persistence.AbstractProcessInstancesFactory"));
        boolean usePersistence = persistenceClass != null;
        List<String> parameters = new ArrayList<String>();
        if (usePersistence) {
            for (MethodInfo mi : persistenceClass.methods()) {
                if (!mi.name().equals("<init>") || mi.parameters().isEmpty()) continue;
                parameters = mi.parameters().stream().map(p -> p.name().toString()).collect(Collectors.toList());
                break;
            }
        }
        if (!(generatedFiles = this.getGeneratedPersistenceFiles(config, appPaths, index, usePersistence, parameters)).isEmpty()) {
            this.writeGeneratedFiles(appPaths, generatedFiles);
            this.compile(appPaths, curateOutcomeBuildItem.getApplicationModel(), generatedFiles, launchMode.getLaunchMode(), generatedBeans, additionalIndexClass, GeneratedBeanBuildItem::new, pconfig);
        }
    }

    private Collection<GeneratedFile> getGeneratedPersistenceFiles(AutomatikoBuildTimeConfig config, AppPaths appPaths, IndexView index, boolean usePersistence, List<String> parameters) {
        Collection modelClasses = index.getAllKnownImplementors(this.createDotName(Model.class.getCanonicalName()));
        ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
        for (Path projectPath : appPaths.projectPaths) {
            PersistenceGenerator persistenceGenerator = new PersistenceGenerator(new File(projectPath.toFile(), "target"), modelClasses, usePersistence, Thread.currentThread().getContextClassLoader());
            persistenceGenerator.setDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator());
            persistenceGenerator.setPackageName(config.packageName.orElse(DEFAULT_PACKAGE_NAME));
            persistenceGenerator.setContext(AutomatikoBuildData.get().getGenerationContext());
            generatedFiles.addAll(persistenceGenerator.generate());
        }
        return generatedFiles;
    }

    private void writeGeneratedFiles(AppPaths appPaths, Collection<GeneratedFile> resourceFiles) {
        for (Path projectPath : appPaths.projectPaths) {
            String restResourcePath = projectPath.resolve(generatedCustomizableSourcesDir).toString();
            String resourcePath = projectPath.resolve(generatedResourcesDir).toString();
            String jsonSchemaPath = projectPath.resolve(generatedResourcesDir).resolve("jsonSchema").toString();
            String sourcePath = projectPath.resolve(generatedSourcesDir).toString();
            for (GeneratedFile f : resourceFiles) {
                try {
                    if (f.getType() == GeneratedFile.Type.RESOURCE) {
                        this.writeGeneratedFile(f, resourcePath);
                        continue;
                    }
                    if (f.getType() == GeneratedFile.Type.JSON_SCHEMA) {
                        this.writeGeneratedFile(f, jsonSchemaPath);
                        continue;
                    }
                    if (f.getType().isCustomizable()) {
                        this.writeGeneratedFile(f, restResourcePath);
                        continue;
                    }
                    this.writeGeneratedFile(f, sourcePath);
                }
                catch (IOException e) {
                    logger.warn(String.format("Could not write file '%s'", f.toString()), (Throwable)e);
                }
            }
        }
    }

    private GeneratedBeanBuildItem generateBeanBuildItem(CompositeIndex archivesIndex, Indexer automatikIndexer, Set<DotName> automatikIndex, String className, byte[] data) {
        IndexingUtil.indexClass((String)className, (Indexer)automatikIndexer, (IndexView)archivesIndex, automatikIndex, (ClassLoader)Thread.currentThread().getContextClassLoader(), (byte[])data);
        return new GeneratedBeanBuildItem(className, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(AppPaths appPaths, ApplicationModel appModel, Collection<GeneratedFile> generatedFiles, LaunchMode launchMode, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexClassProducer, BiFunction<String, byte[], GeneratedBeanBuildItem> bif, PackageConfig config) throws Exception {
        block13: {
            ArrayList<SourceCode> sources = new ArrayList<SourceCode>();
            ArrayList<String> classpaths = new ArrayList<String>();
            ArrayList<String> options = new ArrayList<String>();
            options.add("-proc:none");
            for (Path classPath : appPaths.classesPaths) {
                classpaths.add(classPath.toString());
            }
            if (appModel != null) {
                for (ResolvedDependency i : appModel.getRuntimeDependencies()) {
                    classpaths.add(i.getResolvedPaths().getSinglePath().toAbsolutePath().toString());
                }
            }
            if (!classpaths.isEmpty()) {
                options.add("-classpath");
                options.add(classpaths.stream().collect(Collectors.joining(File.pathSeparator)));
            }
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            DiagnosticCollector diagnosticsCollector = new DiagnosticCollector();
            try (final StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnosticsCollector, null, null);){
                File buildDir = appPaths.getFirstClassesPath().toFile();
                if (buildDir.isFile()) {
                    buildDir = new File(buildDir.getParentFile(), "classes");
                }
                fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(buildDir));
                for (GeneratedFile entry : generatedFiles) {
                    String generatedClassFile = entry.relativePath().replace("src/main/java/", "");
                    String fileName = this.toRuntimeSource(this.toClassName(generatedClassFile));
                    sources.add(new SourceCode(fileName, new String(entry.contents())));
                    String location = this.generatedClassesDir;
                    if (launchMode == LaunchMode.DEVELOPMENT || config.type.equals(PackageConfig.BuiltInType.MUTABLE_JAR.getValue())) {
                        location = Paths.get(buildDir.toString(), new String[0]).toString();
                    }
                    this.writeGeneratedFile(entry, location);
                }
                JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnosticsCollector, options, null, sources);
                boolean result = task.call();
                if (result) {
                    LinkedHashMap<Object, byte[]> classes = new LinkedHashMap<Object, byte[]>();
                    ArrayList<String> classesToIndex = new ArrayList<String>();
                    Iterable<JavaFileObject> compiledClasses = fileManager.list(StandardLocation.CLASS_OUTPUT, "", Collections.singleton(JavaFileObject.Kind.CLASS), true);
                    for (JavaFileObject jfo : compiledClasses) {
                        String clazz = jfo.getName().replaceFirst(buildDir.toString() + "/", "");
                        clazz = this.toClassName(clazz);
                        byte[] content = IoUtils.readBytesFromInputStream((InputStream)jfo.openInputStream());
                        generatedBeans.produce((BuildItem)bif.apply(clazz, content));
                        classesToIndex.add(clazz);
                        classes.put(clazz, content);
                        classes.put(clazz.replaceAll("\\.", "/") + ".class", content);
                    }
                    if (Thread.currentThread().getContextClassLoader() instanceof QuarkusClassLoader) {
                        QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
                        Field f = cl.getClass().getDeclaredField("elements");
                        f.setAccessible(true);
                        List element = (List)f.get(cl);
                        element.add(new MemoryClassPathElement(classes, result){

                            public Path getRoot() {
                                return fileManager.getLocation(StandardLocation.CLASS_OUTPUT).iterator().next().toPath();
                            }
                        });
                        f = cl.getClass().getDeclaredField("state");
                        f.setAccessible(true);
                        f.set(cl, null);
                    }
                    additionalIndexClassProducer.produce((BuildItem)new AdditionalIndexedClassesBuildItem((String[])classesToIndex.toArray(String[]::new)));
                    break block13;
                }
                List diagnostics = diagnosticsCollector.getDiagnostics();
                String errorMessage = diagnostics.stream().map(d -> d.toString()).collect(Collectors.joining(","));
                throw new IllegalStateException(errorMessage);
            }
        }
    }

    private ApplicationGenerator createApplicationGenerator(Capabilities capabilities, AutomatikoBuildTimeConfig config, AppPaths appPaths, CompositeIndex archivesIndex, ApplicationModel appModel, boolean onlyCodeAssets) throws IOException {
        boolean usePersistence = archivesIndex.getClassByName(this.createDotName("io.automatiko.engine.addons.persistence.AbstractProcessInstancesFactory")) != null;
        GeneratorContext context = this.buildContext(capabilities, config, appPaths, (IndexView)archivesIndex);
        ApplicationGenerator appGen = new ApplicationGenerator(config.packageName().orElse(DEFAULT_PACKAGE_NAME), new File(appPaths.getFirstProjectPath().toFile(), "target")).withDependencyInjection((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator()).withPersistence(usePersistence).withGeneratorContext(context);
        ArrayList<String> dependencies = new ArrayList<String>();
        if (appModel != null) {
            for (ResolvedDependency i : appModel.getRuntimeDependencies()) {
                dependencies.add(i.getResolvedPaths().getSinglePath().toAbsolutePath().toString());
            }
        }
        this.addProcessGenerator(appPaths, usePersistence, appGen, dependencies, archivesIndex, onlyCodeAssets);
        if (context.getBuildContext().isDmnSupported()) {
            this.addDecisionGenerator(appPaths, appGen, false, dependencies);
        }
        return appGen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProcessGenerator(AppPaths appPaths, boolean usePersistence, ApplicationGenerator appGen, List<String> dependencies, CompositeIndex index, boolean onlyCodeAssets) throws IOException {
        DotName workflowBuilderDotName = this.createDotName("io.automatiko.engine.workflow.builder.WorkflowBuilder");
        List workflowBuilderClasses = index.getAnnotations(this.createDotName("io.automatiko.engine.api.Workflows"));
        ArrayList<ExecutableProcess> processes = new ArrayList<ExecutableProcess>();
        if (workflowBuilderClasses != null && !workflowBuilderClasses.isEmpty()) {
            for (AnnotationInstance workflowBuilderClass : workflowBuilderClasses) {
                ClassInfo clazz = workflowBuilderClass.target().asClass();
                String fqcn = clazz.name().toString();
                LambdaParser.parseLambdas((String)(appPaths.getFirstProjectPath() + "/src/main/java/" + fqcn.replace(".", "/") + ".java"));
                try {
                    Class<?> builderClass = Class.forName(fqcn, true, Thread.currentThread().getContextClassLoader());
                    Object workflowsBuilderInstance = builderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    List workflowsMethods = clazz.methods().stream().filter(m -> Modifier.isPublic(m.flags()) && m.returnType().name().compareTo(workflowBuilderDotName) == 0).map(m -> m.name()).collect(Collectors.toList());
                    for (String methodName : workflowsMethods) {
                        Method method = workflowsBuilderInstance.getClass().getMethod(methodName, new Class[0]);
                        WorkflowBuilder builder = (WorkflowBuilder)method.invoke(workflowsBuilderInstance, new Object[0]);
                        ExecutableProcess process = builder.get();
                        process.setPackageName(builderClass.getPackageName());
                        processes.add(process);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    BuilderContext.clear();
                }
            }
        }
        ProcessCodegen generator = onlyCodeAssets ? ProcessCodegen.ofProcesses(processes) : (appPaths.isJar ? ProcessCodegen.ofJar(processes, dependencies, (Path[])appPaths.getJarPath()) : ProcessCodegen.ofPath(processes, dependencies, (Path[])appPaths.getProjectPaths()));
        ((ProcessCodegen)appGen.withGenerator((Generator)generator)).withPersistence(usePersistence).withClassLoader(Thread.currentThread().getContextClassLoader());
    }

    private void addDecisionGenerator(AppPaths appPaths, ApplicationGenerator appGen, boolean useMonitoring, List<String> dependencies) throws IOException {
        DecisionCodegen generator = appPaths.isJar ? DecisionCodegen.ofJar(dependencies, (Path[])appPaths.getJarPath()) : DecisionCodegen.ofPath(dependencies, (Path[])appPaths.getResourcePaths());
        ((DecisionCodegen)appGen.withGenerator((Generator)generator)).withMonitoring(useMonitoring);
    }

    private String toRuntimeSource(String className) {
        return "src/main/java/" + className.replace('.', '/') + ".java";
    }

    private String toClassName(String sourceName) {
        if (sourceName.startsWith("./")) {
            sourceName = sourceName.substring(2);
        }
        if (sourceName.endsWith(".java")) {
            sourceName = sourceName.substring(0, sourceName.length() - 5);
        } else if (sourceName.endsWith(".class")) {
            sourceName = sourceName.substring(0, sourceName.length() - 6);
        }
        return sourceName.replace('/', '.');
    }

    private void writeGeneratedFile(GeneratedFile f, String location) throws IOException {
        if (location == null) {
            return;
        }
        String generatedClassFile = f.relativePath().replace("src/main/java", "");
        Path sourceFilePath = this.pathOf(location, generatedClassFile);
        Path classFilePath = this.pathOf(location, generatedClassFile.replaceAll("\\.java", ".class"));
        Files.write(sourceFilePath, f.contents(), new OpenOption[0]);
        AutomatikoBuildData.get().getGenerationContext().addClassToSourceMapping(classFilePath, sourceFilePath);
    }

    private Path pathOf(String location, String end) {
        Path path = Paths.get(location, end);
        path.getParent().toFile().mkdirs();
        return path;
    }

    private DotName createDotName(String name) {
        int lastDot = name.indexOf(46);
        if (lastDot < 0) {
            return DotName.createComponentized(null, (String)name);
        }
        DotName lastDotName = null;
        while (lastDot > 0) {
            String local = name.substring(0, lastDot);
            name = name.substring(lastDot + 1);
            lastDot = name.indexOf(46);
            lastDotName = DotName.createComponentized(lastDotName, (String)local);
        }
        int lastDollar = name.indexOf(36);
        if (lastDollar < 0) {
            return DotName.createComponentized(lastDotName, (String)name);
        }
        DotName lastDollarName = null;
        while (lastDollar > 0) {
            String local = name.substring(0, lastDollar);
            name = name.substring(lastDollar + 1);
            lastDollar = name.indexOf(36);
            if (lastDollarName == null) {
                lastDollarName = DotName.createComponentized((DotName)lastDotName, (String)local);
                continue;
            }
            lastDollarName = DotName.createComponentized((DotName)lastDollarName, (String)local, (boolean)true);
        }
        return DotName.createComponentized(lastDollarName, (String)name, (boolean)true);
    }

    private GeneratorContext buildContext(Capabilities capabilities, AutomatikoBuildTimeConfig config, AppPaths appPaths, IndexView index) {
        GeneratorContext generationContext = QuarkusGeneratorContext.ofResourcePath(appPaths.getResourceFiles()[0], appPaths.getFirstClassesPath().toFile());
        generationContext.withBuildContext((ApplicationBuildContext)new QuarkusApplicationBuildContext((AutomatikoBuildConfig)config, className -> {
            DotName classDotName = this.createDotName((String)className);
            return !index.getAnnotations(classDotName).isEmpty() || index.getClassByName(classDotName) != null;
        }, className -> index.getAllKnownImplementors(this.createDotName((String)className)).stream().map(c -> c.name().toString()).collect(Collectors.toList()), capability -> capabilities.isPresent(capability)));
        return AutomatikoBuildData.create(config, generationContext).getGenerationContext();
    }

    private static class AppPaths {
        private final Set<Path> projectPaths = new LinkedHashSet<Path>();
        private final List<Path> classesPaths = new ArrayList<Path>();
        private boolean isJar = false;

        private AppPaths(PathCollection paths) {
            for (Path path : paths) {
                PathType pathType = this.getPathType(path);
                switch (pathType) {
                    case CLASSES: {
                        this.classesPaths.add(path);
                        this.projectPaths.add(path.getParent().getParent());
                        break;
                    }
                    case TEST_CLASSES: {
                        this.projectPaths.add(path.getParent().getParent());
                        break;
                    }
                    case JAR: {
                        this.isJar = true;
                        this.classesPaths.add(path);
                        this.projectPaths.add(path.getParent().getParent());
                        break;
                    }
                    case UNKNOWN: {
                        this.classesPaths.add(path);
                        this.projectPaths.add(path);
                    }
                }
            }
        }

        public Path getFirstProjectPath() {
            return this.projectPaths.iterator().next();
        }

        public Path getFirstClassesPath() {
            return this.classesPaths.get(0);
        }

        public Path[] getJarPath() {
            if (!this.isJar) {
                throw new IllegalStateException("Not a jar");
            }
            return this.classesPaths.toArray(new Path[this.classesPaths.size()]);
        }

        public File[] getResourceFiles() {
            return (File[])this.projectPaths.stream().map(p -> p.resolve("src/main/resources").toFile()).toArray(File[]::new);
        }

        public Path[] getResourcePaths() {
            return this.transformPaths(this.projectPaths, p -> p.resolve("src/main/resources"));
        }

        public Path[] getProjectPaths() {
            return this.transformPaths(this.projectPaths, Function.identity());
        }

        private Path[] transformPaths(Collection<Path> paths, Function<Path, Path> f) {
            return (Path[])paths.stream().map(f).toArray(Path[]::new);
        }

        private PathType getPathType(Path archiveLocation) {
            String path = archiveLocation.toString();
            if (path.endsWith("target" + File.separator + "classes")) {
                return PathType.CLASSES;
            }
            if (path.endsWith("target" + File.separator + "test-classes")) {
                return PathType.TEST_CLASSES;
            }
            if (path.endsWith(".jar") || path.endsWith(".jar.original")) {
                return PathType.JAR;
            }
            return PathType.UNKNOWN;
        }

        private static enum PathType {
            CLASSES,
            TEST_CLASSES,
            JAR,
            UNKNOWN;

        }
    }

    private static class SourceCode
    extends SimpleJavaFileObject {
        private String contents = null;

        public SourceCode(String className, String contents) throws Exception {
            super(new URI(className), JavaFileObject.Kind.SOURCE);
            this.contents = contents;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.contents;
        }
    }
}

