/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.events.elastic;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.automatiko.engine.api.event.DataEvent;
import io.automatiko.engine.api.event.EventPublisher;
import io.automatiko.engine.services.event.ProcessInstanceDataEvent;
import io.automatiko.engine.services.event.UserTaskInstanceDataEvent;
import io.automatiko.engine.services.event.impl.NodeInstanceEventBody;
import io.automatiko.engine.services.event.impl.ProcessInstanceEventBody;
import io.automatiko.engine.services.event.impl.UserTaskInstanceEventBody;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ElasticEventPublisher
implements EventPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticEventPublisher.class);
    private RestClient restClient;
    private ObjectMapper mapper;
    private Optional<Boolean> audit;
    private Optional<Boolean> instance;
    private Optional<Boolean> tasks;
    private Optional<String> auditIndex;

    @Inject
    public ElasticEventPublisher(RestClient restClient, ObjectMapper mapper, @ConfigProperty(name="quarkus.automatiko.events.elastic.audit") Optional<Boolean> audit, @ConfigProperty(name="quarkus.automatiko.events.elastic.instance") Optional<Boolean> instance, @ConfigProperty(name="quarkus.automatiko.events.elastic.tasks") Optional<Boolean> tasks, @ConfigProperty(name="quarkus.automatiko.events.elastic.audit-index") Optional<String> auditIndex) {
        this.restClient = restClient;
        this.mapper = mapper;
        this.audit = audit;
        this.instance = instance;
        this.tasks = tasks;
        this.auditIndex = auditIndex;
    }

    public void publish(DataEvent<?> event) {
        block14: {
            try {
                if (event instanceof ProcessInstanceDataEvent) {
                    Request request;
                    ProcessInstanceDataEvent pevent = (ProcessInstanceDataEvent)event;
                    if (this.instance.orElse(true).booleanValue()) {
                        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
                        metadata.put("instanceId", ((ProcessInstanceEventBody)pevent.getData()).getId());
                        metadata.put("processId", ((ProcessInstanceEventBody)pevent.getData()).getProcessId());
                        metadata.put("rootInstanceId", ((ProcessInstanceEventBody)pevent.getData()).getRootInstanceId());
                        metadata.put("rootProcessId", ((ProcessInstanceEventBody)pevent.getData()).getRootProcessId());
                        metadata.put("parentInstanceId", ((ProcessInstanceEventBody)pevent.getData()).getParentInstanceId());
                        metadata.put("businessKey", ((ProcessInstanceEventBody)pevent.getData()).getBusinessKey());
                        metadata.put("state", ((ProcessInstanceEventBody)pevent.getData()).getState());
                        metadata.put("tags", ((ProcessInstanceEventBody)pevent.getData()).getTags());
                        if (((ProcessInstanceEventBody)pevent.getData()).getRoles() != null) {
                            metadata.put("roles", ((ProcessInstanceEventBody)pevent.getData()).getRoles());
                        }
                        if (((ProcessInstanceEventBody)pevent.getData()).getVisibleTo() != null) {
                            metadata.put("visibleTo", ((ProcessInstanceEventBody)pevent.getData()).getVisibleTo());
                        }
                        metadata.put("startDate", ((ProcessInstanceEventBody)pevent.getData()).getStartDate());
                        metadata.put("endDate", ((ProcessInstanceEventBody)pevent.getData()).getEndDate());
                        LinkedHashMap<String, LinkedHashMap<String, Object>> payload = new LinkedHashMap<String, LinkedHashMap<String, Object>>(((ProcessInstanceEventBody)pevent.getData()).getVariables());
                        payload.put("_metadata", metadata);
                        request = new Request("PUT", "/" + ((ProcessInstanceEventBody)pevent.getData()).sourceInstance().process().id() + "/_doc/" + ((ProcessInstanceEventBody)pevent.getData()).getId());
                        request.setJsonEntity(this.mapper.writeValueAsString(payload));
                        this.sendRequest(request, event);
                    }
                    if (this.audit.orElse(false).booleanValue()) {
                        String index = this.auditIndex.orElse("atk_audit");
                        StringBuilder bulkRequestBody = new StringBuilder();
                        for (NodeInstanceEventBody nevent : ((ProcessInstanceEventBody)pevent.getData()).getNodeInstances()) {
                            String actionMetaData = String.format("{ \"index\" : { \"_index\" : \"%s\", \"_id\" : \"%s\" } }%n", index, nevent.getId());
                            LinkedHashMap<String, Object> audit = new LinkedHashMap<String, Object>();
                            audit.put("instanceId", ((ProcessInstanceEventBody)pevent.getData()).getId());
                            audit.put("processId", ((ProcessInstanceEventBody)pevent.getData()).getProcessId());
                            audit.put("rootInstanceId", ((ProcessInstanceEventBody)pevent.getData()).getRootInstanceId());
                            audit.put("rootProcessId", ((ProcessInstanceEventBody)pevent.getData()).getRootProcessId());
                            audit.put("parentInstanceId", ((ProcessInstanceEventBody)pevent.getData()).getParentInstanceId());
                            audit.put("businessKey", ((ProcessInstanceEventBody)pevent.getData()).getBusinessKey());
                            audit.put("nodeDefinitionId", nevent.getNodeDefinitionId());
                            audit.put("nodeId", nevent.getNodeId());
                            audit.put("nodeName", nevent.getNodeName());
                            audit.put("nodeType", nevent.getNodeType());
                            audit.put("triggerTime", nevent.getTriggerTime());
                            audit.put("leaveTime", nevent.getLeaveTime());
                            bulkRequestBody.append(actionMetaData);
                            bulkRequestBody.append(this.mapper.writeValueAsString(audit));
                            bulkRequestBody.append("\n");
                        }
                        request = new Request("POST", "/" + index + "/_bulk");
                        request.setJsonEntity(bulkRequestBody.toString());
                        this.sendRequest(request, event);
                    }
                    break block14;
                }
                if (event instanceof UserTaskInstanceDataEvent && this.tasks.orElse(true).booleanValue()) {
                    UserTaskInstanceDataEvent uevent = (UserTaskInstanceDataEvent)event;
                    LinkedHashSet potentialOwners = new LinkedHashSet();
                    if (((UserTaskInstanceEventBody)uevent.getData()).getPotentialUsers() != null) {
                        potentialOwners.addAll(((UserTaskInstanceEventBody)uevent.getData()).getPotentialUsers());
                    }
                    if (((UserTaskInstanceEventBody)uevent.getData()).getPotentialGroups() != null) {
                        potentialOwners.addAll(((UserTaskInstanceEventBody)uevent.getData()).getPotentialGroups());
                    }
                    if (((UserTaskInstanceEventBody)uevent.getData()).getAdminUsers() != null) {
                        potentialOwners.addAll(((UserTaskInstanceEventBody)uevent.getData()).getAdminUsers());
                    }
                    if (((UserTaskInstanceEventBody)uevent.getData()).getAdminGroups() != null) {
                        potentialOwners.addAll(((UserTaskInstanceEventBody)uevent.getData()).getAdminUsers());
                    }
                    if (((UserTaskInstanceEventBody)uevent.getData()).getExcludedUsers() != null) {
                        potentialOwners.removeAll(((UserTaskInstanceEventBody)uevent.getData()).getExcludedUsers());
                    }
                    LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
                    metadata.put("processInstanceId", ((UserTaskInstanceEventBody)uevent.getData()).getProcessInstanceId());
                    metadata.put("processId", ((UserTaskInstanceEventBody)uevent.getData()).getProcessId());
                    metadata.put("rootInstanceId", ((UserTaskInstanceEventBody)uevent.getData()).getRootProcessInstanceId());
                    metadata.put("rootProcessId", ((UserTaskInstanceEventBody)uevent.getData()).getRootProcessId());
                    metadata.put("referenceName", ((UserTaskInstanceEventBody)uevent.getData()).getReferenceName());
                    LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
                    payload.put("instanceId", ((UserTaskInstanceEventBody)uevent.getData()).getId());
                    payload.put("name", ((UserTaskInstanceEventBody)uevent.getData()).getTaskName());
                    payload.put("description", ((UserTaskInstanceEventBody)uevent.getData()).getTaskDescription());
                    payload.put("state", ((UserTaskInstanceEventBody)uevent.getData()).getState());
                    payload.put("owner", ((UserTaskInstanceEventBody)uevent.getData()).getActualOwner());
                    payload.put("potentialOwners", potentialOwners);
                    payload.put("excludedUsers", ((UserTaskInstanceEventBody)uevent.getData()).getExcludedUsers());
                    payload.put("startDate", ((UserTaskInstanceEventBody)uevent.getData()).getStartDate());
                    payload.put("endDate", ((UserTaskInstanceEventBody)uevent.getData()).getCompleteDate());
                    payload.put("inputs", ((UserTaskInstanceEventBody)uevent.getData()).getInputs());
                    payload.put("outputs", ((UserTaskInstanceEventBody)uevent.getData()).getOutputs());
                    payload.put("_metadata", metadata);
                    Request request = new Request("PUT", "/tasks/_doc/" + ((UserTaskInstanceEventBody)uevent.getData()).getId());
                    request.setJsonEntity(this.mapper.writeValueAsString(payload));
                    this.sendRequest(request, event);
                    break block14;
                }
                return;
            }
            catch (IOException e) {
                LOGGER.error("Error when publishing event to elastic", (Throwable)e);
            }
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        for (DataEvent<?> event : events) {
            this.publish(event);
        }
    }

    protected void sendRequest(Request request, final DataEvent<?> event) {
        this.restClient.performRequestAsync(request, new ResponseListener(){

            public void onSuccess(Response response) {
                LOGGER.debug("Event {} successfully published to elastic", (Object)event);
            }

            public void onFailure(Exception exception) {
                LOGGER.error("Event {} failed to be published to elastic", (Object)event, (Object)exception);
            }
        });
    }
}

