/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.v2;

import io.atlasmap.json.v2.JsonDocument;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.Fields;
import java.util.ArrayList;

public class AtlasJsonModelFactory {
    public static final String URI_FORMAT = "atlas:json";

    public static JsonDocument createJsonDocument() {
        JsonDocument jsonDocument = new JsonDocument();
        jsonDocument.setFields(new Fields());
        return jsonDocument;
    }

    public static JsonField createJsonField() {
        JsonField jsonField = new JsonField();
        return jsonField;
    }

    public static String toString(JsonField f) {
        return "JsonField [name=" + f.getName() + ", primitive=" + f.isPrimitive() + ", typeName=" + f.getTypeName() + ", userCreated=" + f.isUserCreated() + ", actions=" + f.getActions() + ", value=" + f.getValue() + ", arrayDimensions=" + f.getArrayDimensions() + ", arraySize=" + f.getArraySize() + ", collectionType=" + f.getCollectionType() + ", docId=" + f.getDocId() + ", index=" + f.getIndex() + ", path=" + f.getPath() + ", required=" + f.isRequired() + ", status=" + f.getStatus() + ", fieldType=" + f.getFieldType() + "]";
    }

    public static JsonField cloneField(JsonField field, boolean withActions) {
        JsonField clone = new JsonField();
        AtlasJsonModelFactory.copyField(field, clone, withActions);
        return clone;
    }

    public static FieldGroup cloneFieldGroup(FieldGroup group) {
        FieldGroup clone = AtlasModelFactory.copyFieldGroup((FieldGroup)group);
        ArrayList<Object> newChildren = new ArrayList<Object>();
        for (Field child : group.getField()) {
            if (child instanceof FieldGroup) {
                newChildren.add(AtlasJsonModelFactory.cloneFieldGroup((FieldGroup)child));
                continue;
            }
            newChildren.add(AtlasJsonModelFactory.cloneField((JsonField)child, true));
        }
        clone.getField().addAll(newChildren);
        return clone;
    }

    public static void copyField(Field from, Field to, boolean withActions) {
        AtlasModelFactory.copyField((Field)from, (Field)to, (boolean)withActions);
        if (from instanceof JsonField && to instanceof JsonField) {
            JsonField fromJson = (JsonField)from;
            JsonField toJson = (JsonField)to;
            toJson.setName(fromJson.getName());
            toJson.setPrimitive(fromJson.isPrimitive());
            toJson.setTypeName(fromJson.getTypeName());
            toJson.setUserCreated(fromJson.isUserCreated());
        }
    }
}

