/*
 * Decompiled with CFR 0.152.
 */
package cucumber.fallback.runtime.java;

import cucumber.runtime.CucumberException;
import cucumber.runtime.java.ObjectFactory;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultJavaObjectFactory
implements ObjectFactory {
    private final Set<Class<?>> classes = new HashSet();
    private final Map<Class<?>, Object> instances = new HashMap();

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.instances.clear();
    }

    @Override
    public void addClass(Class<?> clazz) {
        this.classes.add(clazz);
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        Object instance = this.instances.get(type);
        if (instance == null) {
            instance = this.cacheNewInstance(type);
        }
        return (T)instance;
    }

    private <T> T cacheNewInstance(Class<T> type) {
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            T instance = constructor.newInstance(new Object[0]);
            this.instances.put(type, instance);
            return instance;
        }
        catch (NoSuchMethodException e) {
            throw new CucumberException(String.format("%s doesn't have an empty constructor. If you need DI, put cucumber-picocontainer on the classpath", type), (Throwable)e);
        }
        catch (Exception e) {
            throw new CucumberException(String.format("Failed to instantiate %s", type), (Throwable)e);
        }
    }
}

