/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.execution.ExpressionResult;

public class Cache {
    private boolean enableExpressionCache = false;
    private Map<FunctionRef, FunctionDef> functionCache = new HashMap<FunctionRef, FunctionDef>();
    private Map<VersionedIdentifier, Map<String, ExpressionResult>> expressions = new LinkedHashMap<VersionedIdentifier, Map<String, ExpressionResult>>(10, 0.9f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<VersionedIdentifier, Map<String, ExpressionResult>> eldestEntry) {
            return this.size() > 10;
        }
    };

    protected Map<String, ExpressionResult> constructLibraryExpressionHashMap() {
        return new LinkedHashMap<String, ExpressionResult>(15, 0.9f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ExpressionResult> eldestEntry) {
                return this.size() > 15;
            }
        };
    }

    public Map<VersionedIdentifier, Map<String, ExpressionResult>> getExpressions() {
        return this.expressions;
    }

    public void setExpressionCaching(boolean yayOrNay) {
        this.enableExpressionCache = yayOrNay;
    }

    protected Map<String, ExpressionResult> getExpressionCache(VersionedIdentifier libraryId) {
        return this.getExpressions().computeIfAbsent(libraryId, k -> this.constructLibraryExpressionHashMap());
    }

    public boolean isExpressionCached(VersionedIdentifier libraryId, String name) {
        return this.getExpressionCache(libraryId).containsKey(name);
    }

    public boolean isExpressionCachingEnabled() {
        return this.enableExpressionCache;
    }

    public void cacheExpression(VersionedIdentifier libraryId, String name, ExpressionResult er) {
        this.getExpressionCache(libraryId).put(name, er);
    }

    public ExpressionResult getCachedExpression(VersionedIdentifier libraryId, String name) {
        return this.getExpressionCache(libraryId).get(name);
    }

    public Map<FunctionRef, FunctionDef> getFunctionCache() {
        return this.functionCache;
    }

    public void cacheFunctionDef(FunctionRef functionRef, FunctionDef functionDef) {
        this.functionCache.put(functionRef, functionDef);
    }

    public FunctionDef getCachedFunctionDef(FunctionRef functionRef) {
        return this.getCachedFunctionDef(functionRef);
    }
}

