/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.hl7.elm.r1.CodeSystemRef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.ValueSetRef;
import org.opencds.cqf.cql.engine.elm.executing.CodeSystemRefEvaluator;
import org.opencds.cqf.cql.engine.execution.Libraries;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.CodeSystem;
import org.opencds.cqf.cql.engine.runtime.ValueSet;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;

public class ValueSetRefEvaluator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValueSet toValueSet(State state, ValueSetRef vsr) {
        boolean enteredLibrary = state.enterLibrary(vsr.getLibraryName());
        try {
            ValueSetDef vsd = Libraries.resolveValueSetRef(vsr.getName(), state.getCurrentLibrary());
            ValueSet vs = new ValueSet().withId(vsd.getId()).withVersion(vsd.getVersion());
            for (CodeSystemRef csr : vsd.getCodeSystem()) {
                CodeSystem cs = CodeSystemRefEvaluator.toCodeSystem(csr, state);
                vs.addCodeSystem(cs);
            }
            ValueSet valueSet = vs;
            return valueSet;
        }
        finally {
            state.exitLibrary(enteredLibrary);
        }
    }

    public static Object internalEvaluate(State state, ValueSetRef vsr) {
        ValueSet vs = ValueSetRefEvaluator.toValueSet(state, vsr);
        if (vsr.isPreserve() != null && vsr.isPreserve().booleanValue()) {
            return vs;
        }
        TerminologyProvider tp = state.getEnvironment().getTerminologyProvider();
        return tp.expand(ValueSetInfo.fromValueSet(vs));
    }
}

