/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.runtime.Value;

public class ToLongEvaluator {
    public static Object toLong(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof Boolean) {
            return (Boolean)operand != false ? 1 : 0;
        }
        if (operand instanceof Integer) {
            return (long)((Integer)operand).intValue();
        }
        if (operand instanceof String) {
            try {
                return Long.parseLong((String)operand);
            }
            catch (NumberFormatException nfe) {
                try {
                    Double ret = Double.parseDouble((String)operand);
                    if (Value.validateLong(ret) == null) {
                        return null;
                    }
                    return ret.longValue();
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        throw new InvalidOperatorArgument("ToLong(String)", String.format("ToLong(%s)", operand.getClass().getName()));
    }
}

