/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import org.opencds.cqf.cql.engine.elm.executing.GreaterOrEqualEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;

public class SameOrAfterEvaluator {
    public static Boolean onOrAfter(Object left, Object right, String precision, State state) {
        if (left instanceof Interval && right instanceof Interval) {
            if (((Interval)left).getStart() instanceof BaseTemporal) {
                return SameOrAfterEvaluator.sameOrAfter(((Interval)left).getStart(), ((Interval)right).getEnd(), precision, state);
            }
            return GreaterOrEqualEvaluator.greaterOrEqual(((Interval)left).getStart(), ((Interval)right).getEnd(), state);
        }
        if (left instanceof Interval) {
            if (right instanceof BaseTemporal) {
                return SameOrAfterEvaluator.sameOrAfter(((Interval)left).getStart(), right, precision, state);
            }
            return GreaterOrEqualEvaluator.greaterOrEqual(((Interval)left).getStart(), right, state);
        }
        if (right instanceof Interval) {
            if (left instanceof BaseTemporal) {
                return SameOrAfterEvaluator.sameOrAfter(left, ((Interval)right).getEnd(), precision, state);
            }
            return GreaterOrEqualEvaluator.greaterOrEqual(left, ((Interval)right).getEnd(), state);
        }
        throw new InvalidOperatorArgument("OnOrAfter(Date, Date), OnOrAfter(DateTime, DateTime), OnOrAfter(Time, Time), OnOrAfter(Interval<T>, Interval<T>), OnOrAfter(T, Interval<T>) or OnOrAfter(Interval<T>, T)", String.format("OnOrAfter(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    public static Boolean sameOrAfter(Object left, Object right, String precision, State state) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval || right instanceof Interval) {
            return SameOrAfterEvaluator.onOrAfter(left, right, precision, state);
        }
        if (precision == null) {
            precision = BaseTemporal.getHighestPrecision((BaseTemporal)left, (BaseTemporal)right);
        }
        if (left instanceof BaseTemporal && right instanceof BaseTemporal) {
            Integer result = ((BaseTemporal)left).compareToPrecision((BaseTemporal)right, Precision.fromString(precision));
            return result == null ? null : Boolean.valueOf(result == 0 || result > 0);
        }
        throw new InvalidOperatorArgument("SameOrAfter(Date, Date), SameOrAfter(DateTime, DateTime), SameOrAfter(Time, Time), SameOrAfter(Interval<T>, Interval<T>), SameOrAfter(T, Interval<T>) or SameOrAfter(Interval<T>, T)", String.format("SameOrAfter(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

