/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.cqframework.cql.elm.visiting.ElmLibraryVisitor;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.Literal;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.State;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class NegateEvaluator {
    public static Object negate(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Integer) {
            return -((Integer)source).intValue();
        }
        if (source instanceof Long) {
            return -((Long)source).longValue();
        }
        if (source instanceof BigDecimal) {
            return ((BigDecimal)source).negate();
        }
        if (source instanceof Quantity) {
            Quantity quantity = (Quantity)source;
            return new Quantity().withValue(quantity.getValue().negate()).withUnit(quantity.getUnit());
        }
        throw new InvalidOperatorArgument("Negate(Integer), Negate(Long), Negate(Decimal) or Negate(Quantity)", String.format("Negate(%s)", source.getClass().getName()));
    }

    public static Object internalEvaluate(Expression operand, State state, ElmLibraryVisitor<Object, State> visitor) {
        if (operand instanceof Literal && ((Literal)operand).getValue().equals("2147483648")) {
            return Integer.MIN_VALUE;
        }
        if (operand instanceof Literal && ((Literal)operand).getValue().equals("9223372036854775807")) {
            return Long.MIN_VALUE;
        }
        Object source = visitor.visitExpression(operand, (Object)state);
        return NegateEvaluator.negate(source);
    }
}

